#include "mbed.h"
#include "F746_BUTTON.hpp"

TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;

InterruptIn button1(USER_BUTTON);
volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Used for debouncing
Timeout button1_timeout; // Used for debouncing

void button1_enabled_cb(void)
{
    button1_enabled = true;
}

// ISR handling button pressed event
void button1_onpressed_cb(void)
{
    if (button1_enabled) { // Disabled while the button is bouncing
        button1_enabled = false;
        button1_pressed = true; // To be read by the main loop
        button1_timeout.attach(callback(button1_enabled_cb), 0.3); // Debounce time 300 ms
    }
}

char char_SliderDisplayValue[4];    // String Value to display for the Slider Control value 
uint16_t SliderDisplayValue_;       // Variable used to access Slider Control Value in F746SLIDER.cpp
DigitalOut led(LED1);
int main()
{
    lcd_.Clear(LCD_COLOR_WHITE);                                        // Set LCD Background colour
   
    Button btn1(lcd_, ts_, 20, 50, 80, 40,           
                 LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 1, "NUTNHAN", Font12);  // Define btn1 button            
    btn1.Render();                                                         // Draw btn1 button
    button1.fall(callback(button1_onpressed_cb)); // Attach ISR to handle button press event

    int idx = 0; // Just for printf below
    while (true)                                                    // Main program loop
    {                                                                                      
  
        if (btn1.Press())                                         // Check if btn1 button was touched and run instructions if true
        {    
            lcd_.SetFont(&Font12);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            led = !led;
            wait(0.5); 
            lcd_.DisplayStringAt(5, 110, (uint8_t *)"", LEFT_MODE);
        }                                                           // End btn1 button instructions
        if (button1_pressed) { // Set when button is pressed
            button1_pressed = false;
            led = !led;
            char *tmp;
            sprintf(tmp, "Button pressed %d", idx++);
            wait(0.5);
            lcd_.SetFont(&Font20);
            
            lcd_.DisplayStringAt(5, 160, (uint8_t *)tmp, LEFT_MODE);
            wait(0.5);
        }                                            
        wait(0.02f);   
    }                                                              
}                                                              
