#include "mbed.h"
#include "Motor.h"
#include "SDFileSystem.h" 
#include "rtos.h"

#define SONG_SIZE 60

//Class to control an RGB LED using three PWM pins
class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};

RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}

void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}


class microphone
{
public :
    microphone(PinName pin);
    float read();
    operator float ();
private :
    AnalogIn _pin;
};
microphone::microphone (PinName pin):
    _pin(pin)
{
}
float microphone::read()
{
    return _pin.read();
}
inline microphone::operator float ()
{
    return _pin.read();
}


//Setup RGB led using PWM pins and class
microphone mymicrophone(p16);
RGBLed myRGBled(p25,p24,p23); //RGB PWM pins
Motor small(p21, p30, p29); // pins for large drum // pwm, fwd, rev
Motor largex`(p22, p6, p5); // pins for small drum
Serial blue(p28,p27); // pins for bluetooth module serial
Serial pc(USBTX,USBRX);
SDFileSystem sd(p11, p12, p13, p14, "sd");
Timer timer; // Timer to  for when recorded song is playing
Thread led_thread;
char buffer[SONG_SIZE];

DigitalOut smallLED(LED1);
DigitalOut largeLED(LED2);
DigitalOut bothLED(LED3);
DigitalOut led4(LED4);
int toggle = 0;

FILE *nfp = fopen("/sd/sdtest1.txt", "r");


float strikelength = .15; // amount of time in seconds that the motor will run when striking
float bpm = 240.0; // bpm of recorded song, 240 bpm is nearing the fastest that we can go
float intensity = 0.0;
volatile int color = 0;
float recover = .15;
float initial = .01;

//void light_leds() {
//    while (true) {
//        intensity = abs((mymicrophone - (0.67/3.3)));
//        myRGBled.write(((color == 1) ? intensity : 0), ((color == 2) ? intensity : 0),((color == 3) ? intensity : 0));
//    }
//    
//}
// Hit the small drum
void small_hit(void) {
    //pc.printf("Small drum hit");
    myRGBled.write(1,1,0);
    smallLED = 1;
    wait(.1);
    smallLED = 0;
    color = 2;
    small.speed(1.0);
    wait(strikelength);
    small.speed(0);
    wait(initial);
    small.speed(-1.0);
    wait(recover);
    small.speed(0);
    myRGBled.write(0,0,0);
}

// Hit large drum
void large_hit(void) {
    //pc.printf("Large drum hit");
    myRGBled.write(1,1,0);
    largeLED = 1;
    wait(.1);
    largeLED = 0;
    color = 1;
    large.speed(1.0);
    wait(strikelength);
    large.speed(0);
    wait(initial);
    large.speed(-1.0);
    wait(recover);
    large.speed(0);
    myRGBled.write(0,0,0);
}

// Hit both drums
void both_hit(void) {
    //pc.printf("Both drum hit");
    myRGBled.write(0,0,1);
    bothLED = 1;
    wait(.1);
    bothLED = 0;
    color = 3;
    small.speed(1.0);
    large.speed(1.0);
    wait(strikelength);
    small.speed(0);
    large.speed(0);
    wait(initial);
    small.speed(-1.0);
    large.speed(-1.0);
    wait(recover);
    small.speed(0);
    large.speed(0);
    myRGBled.write(0,0,0);
}



int main() {
    //pc.printf("Program Start");
    //small.speed(.5);
    //large.speed(.5);
    if(nfp == NULL) {
        error("Could not open file for read\n");
    }
    //led_thread.start(light_leds);
    
    led4 = 1;
    
    while(true) {
        led4 = toggle;
        toggle = (toggle == 0) ? 1 : 0;
        if (blue.getc() == '!') { // The message should just be '!' and then a number 0-3. Ex. '!0','!1',...
            //pc.printf("Bluetooth message recieved");
            // '!0' and any other number corresponds to no action
            if (blue.getc() == 'B') {
                char c = blue.getc();
                if (blue.getc() == '1') {
                    if (c == '1') large_hit();
                    else if (c == '2') small_hit();
                    else if (c == '3') both_hit();
                    else {
                        fgets(buffer,SONG_SIZE,nfp);
                        for (int i = 0; i < sizeof(buffer); i++) {
                            // A char is 8 bits, so it can encode for notes
                            // for (int j = 0; j < 4; j++) {
                            timer.reset();
                            if (buffer[i] == NULL) break;
                            switch(buffer[i]) {
                                case '1': large_hit();
                                case '2': small_hit();
                                case '3': both_hit();
                            }
                            // Play the notes or rests at 240 bpm
                            //while (timer < 60.0/bpm);
                        }
                    }
                }
                
            }
        }    
    }
    
    return 0;
}



//#include "mbed.h"
//#include "SDFileSystem.h"
// 
//SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
//Serial pc(USBTX, USBRX);
// 
//char buffer[128];
//
//int main() {
//    printf("Hello World!\n");   
// 
//    mkdir("/sd/mydir", 0777);
//    
//    FILE *fp = fopen("/sd/mydir/sdtest1.txt", "w");
//    if(fp == NULL) {
//        error("Could not open file for write\n");
//    }
//    fprintf(fp, "Hello fun SD Card World!");
//    fclose(fp);
//
//    FILE *nfp = fopen("/sd/mydir/sdtest1.txt", "r");
//    if(nfp == NULL) {
//        error("Could not open file for read\n");
//    }
//
//    fgets(buffer,128,nfp);
    //printf(buffer);
//}
