#ifndef mecanum2017_2_H
#define mecanum2017_2_H
#include "mbed.h"
#define PI 3.141592654
/*
Motor

 \\ 2--------1 // 
    |        |
    |        |
 // 3--------4 \\
*/
class mecanum2017_2
{
    private:
        P_motor m1, m2, m3, m4;
        //Timer timer;
        float* para;
        double alpha, beta;
        //double speed;
        double get_angle(short xdata, short ydata);
        short get_magnitude(short xdata, short ydata, short max);
        short map(short value, short fromLow, short fromHigh, short toLow, short toHigh);
        // void acceleration();
        // void speed_reset();
    public:
        mecanum2017_2(I2C* i2c_, float* para_, char addr[], float rate_, int phase);//paraはモーターの回転方向を±1で表すよ いつもは全部+1だよ
        void move(short xdata_L, short ydata_L, short xdata_R = 0);
        void anglemove(double angle);
        void stop();
        void set_rate(double rate_);
};
#endif