#include "mbed.h"
#include "T_motor.h"
#include "mecanum2017.h"

mecanum2017::mecanum2017(I2C* i2c_, float para[], char addr[], int phase) //paraはモーターの回転方向を±1で表すよ いつもは全部+1だよ
    : m1(i2c_, addr[0]), m2(i2c_, addr[1]), m3(i2c_, addr[2]), m4(i2c_, addr[3])
{
    para1 = para[0];
    para2 = para[1];
    para3 = para[2];
    para4 = para[3];
    oldangle = 0.0;
    alpha = PI / 4;
    beta = phase * (PI / 2); //phaseは初期角度の指定 左に90°で-1, 右に90°で+1
    sokudo = 0.28;
}

/* うごけー */
void mecanum2017::move(int xdate, int ydate) //xdate, ydateは -64 ~ +64
{
    //if(xdate == 0 && ydate == 0) free();
    kasoku();
    double angle = atan2(double(ydate), double(xdate)) + beta; //入力の角度
    if(angle == oldangle); //前回と角度が同じだったらそのまま
    else
    {
        m1 = float(para1 * sokudo * sin(angle - alpha));
        m2 = float(para2 * sokudo * sin(angle + alpha));
        m3 = float(para3 * sokudo * sin(angle - alpha));
        m4 = float(para4 * sokudo * sin(angle + alpha));
    }
    oldangle = angle; // 今回の角度を記憶
}

/*かくどー*/
void mecanum2017::anglemove(double angle)
{
    if(angle != 10)//10 == NONE_angle
    {
        kasoku();
        angle += beta;
        if(angle == oldangle); //前回と角度が同じだったらそのまま
        else
        {
            m1 = float(para1 * sokudo * sin(angle - alpha));
            m2 = float(para2 * sokudo * sin(angle + alpha));
            m3 = float(para3 * sokudo * sin(angle - alpha));
            m4 = float(para4 * sokudo * sin(angle + alpha));
        }
        oldangle = angle; // 今回の角度を記憶
    }
    else free();
}

/* まわれー */
void mecanum2017::rotation(int rxdate)
{
    kasoku();
    m1 = para1 * sokudo * -rxdate * 0.015625; // 1 / 64 = 0.015625
    m2 = para2 * sokudo *  rxdate * 0.015625;
    m3 = para3 * sokudo *  rxdate * 0.015625;
    m4 = para4 * sokudo * -rxdate * 0.015625;
}

/* とまれー */
void mecanum2017::stop()
{
    m1.stop();
    m2.stop();
    m3.stop();
    m4.stop();
    oldangle = 10;
    timer.reset();
}

/*そのままー*/
void mecanum2017::free()
{
    m1.free();
    m2.free();
    m3.free();
    m4.free();
    oldangle = 10;
    timer.reset();
}

void mecanum2017::kasoku()
{
    int time = timer.read_ms();
    if(time < 1000)
    {
        if(time == 0)
        {
            timer.start();
            time = 10;
        }
        if(time >= 1000) timer.stop();
        sokudo = time / 1000.0f; //ms * 1000 / 10;
        oldangle = 10;
    }
}