#include "mbed.h"
#include "ds3_si.h"

ds3_si::ds3_si(PinName tx, PinName rx, int baudrate):serial(tx, rx)
{
    in[0] = 128;
    in[1] = 0;
    in[2] = 0;
    in[3] = 64;
    in[4] = 64;
    in[5] = 64;
    in[6] = 64;
    in[7] = 0;
    
    serial.baud(baudrate);
    serial.attach(callback(this, &ds3_si::serialin), Serial::RxIrq);
}

void ds3_si::serialin()
{
    if(serial.readable())
    {
        while(serial.getc() != 128) {}
        for(short i = 1; i < 8; i++)
        {
            *(in + i) = serial.getc();
        }
    }
}

bool ds3_si::buttonstate(short order)
{
    return in[(order >> 7) + 1] & order;
}

int ds3_si::analogstate(short order)
{
    return (order % 2) ? in[order] - 64 : 64 - in[order];
}

int ds3_si::getinputdata(short order)
{
    return in[order];
}

double ds3_si::getangle(short order)
{
    int x = analogstate(order * 2 + 1);
    int y = analogstate(order * 2 + 2);
    if(x || y)  return atan2(double(y), double(x));
    else        return NONE_angle;
}