#ifndef P_motor_h_
#define P_motor_h_

#include "mbed.h"
#include "T_motor.h"

class P_motor
{
  private:
    T_motor motor;
    Timer timer;
    Serial pc;
    double output[3];
    double target, output_m;
    double time_old;
    double RC, LC;
    void compute();
    void timer_reset();
    void output_reset(double value = 0);
    enum status
    {
      NONE,
      FORWARD,
      BACKWARD = -1
    }stat, stat_old;

  public:
    P_motor(I2C *i2c_, char addr_);
    P_motor& operator=(double target_);
    void direct_controll(double target_);
    void run();
    void free();
    void stop();
};

#endif