#ifndef PID_H
#define PID_H
#include "mbed.h"

enum INDEX{
	NOW,
	OLD,
	TWO_OLD,
	INDEX_NUMBER,
};

enum RESULT{
	P,
	I,
	D,
	OUTPUT,
	RESULT_NUMBER
};

namespace pid_constant{
	const float UPPER_LIMIT =  1.0f;
	const float LOWER_LIMIT = -1.0f;
};

class PositionPid{
    public:
        void period(float control_cycle);
        void gain(float kp_, float ki_, float kd_);
        void reset();
        
        void cal(float current,float target);
        
        float getState(int channel);
        
		
	private:
		float result[RESULT_NUMBER];	// = {P計算値, I計算値, D計算値, 出力値};
		float difference[INDEX_NUMBER]; // = {現在の目標値と現在値の差分, 1つ前の目標値と現在地の差分};
		float distance[INDEX_NUMBER];	// = {現在の位置, 1つ前のい位置};
		float kp, ki, kd, dt,dt_reciprocal;
			  
};

class SpeedPid{
	public:				
		void cal(float target_speed, float now_speed);
			
		float getState(int channel);
		
        void init(float kp_, float ki_, float kd_, float dt_);
	private:
		float 	dt,
				gain[RESULT_NUMBER],
				diffelence[RESULT_NUMBER],
				result[RESULT_NUMBER];

};


#endif
