/*
Copyright (c) 2019 Flow design labs, Project RAMA R01

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "RamaGNSS.h"
#include "Other/DebuggerColors.h"

RamaGNSS::RamaGNSS(Serial &gnss/*, Serial &debugger*/) : _gnss(gnss)/*, _debugger(debugger)*/
{
    _gnss.baud(9600);
    //_debugger.baud(9600);
}

bool RamaGNSS::parseNMEA(char *nmeaSentence)
{
    if (NULL != strstr(nmeaSentence, "$GNGGA")) {
        char *p = nmeaSentence;

        // parse time
        p = strchr(p, ',')+1;
        float timef = atof(p);
        uint32_t time = timef;
        hour = time / 10000;
        minute = (time % 10000) / 100;
        seconds = (time % 100);
        milliseconds = fmod((double) timef, 1.0) * 1000;

        // parse latitude
        p = strchr(p, ',')+1;
        latitude = atof(p);
        p = strchr(p, ',')+1;
        if (p[0] == 'N') headingLatitude = 'N';
        else if (p[0] == 'S') headingLatitude = 'S';
        else if (p[0] == ',') headingLatitude = 0;
        else return false;

        // parse longitude
        p = strchr(p, ',')+1;
        longitude = atof(p);
        p = strchr(p, ',')+1;
        if (p[0] == 'W') headingLongitude = 'W';
        else if (p[0] == 'E') headingLongitude = 'E';
        else if (p[0] == ',') headingLongitude = 0;
        else return false;

        // parse fixquality
        p = strchr(p, ',')+1;
        fixquality = atoi(p);

        // parse satellites
        p = strchr(p, ',')+1;
        satelliteCount = atoi(p);

        // parse HDOP
        p = strchr(p, ',')+1;
        HDOP = atof(p);

        // parse altitude
        p = strchr(p, ',')+1;
        altitude = atof(p);

        // parse geoidheight
        p = strchr(p, ',')+1;
        p = strchr(p, ',')+1;
        geoidHeight = atof(p);
        return true;
    }

    if (NULL != strstr(nmeaSentence, "$GNRMC")) {
        char *p = nmeaSentence;

        // parse time
        p = strchr(p, ',')+1;
        float timef = atof(p);
        uint32_t time = timef;
        hour = time / 10000;
        minute = (time % 10000) / 100;
        seconds = (time % 100);
        milliseconds = fmod((double) timef, 1.0) * 1000;

        p = strchr(p, ',')+1;
        satelliteFixValue = p[0];
        if (p[0] == 'A')
            isFixed = true;
        else if (p[0] == 'V')
            isFixed = false;
        else
            return false;

        // parse latitude
        p = strchr(p, ',')+1;
        latitude = atof(p);

        // parse heading 01
        p = strchr(p, ',')+1;
        if (p[0] == 'N') headingLatitude = 'N';
        else if (p[0] == 'S') headingLatitude = 'S';
        else if (p[0] == ',') headingLatitude = 0;
        else return false;

        // parse longitude
        p = strchr(p, ',')+1;
        longitude = atof(p);

        // parse heading 02
        p = strchr(p, ',')+1;
        if (p[0] == 'W') headingLongitude = 'W';
        else if (p[0] == 'E') headingLongitude = 'E';
        else if (p[0] == ',') headingLongitude = 0;
        else return false;

        // parse speed
        p = strchr(p, ',')+1;
        speed = atof(p);

        // parse angle
        p = strchr(p, ',')+1;
        angle = atof(p);

        // parse time
        p = strchr(p, ',')+1;
        uint32_t fulldate = atof(p);
        day = fulldate / 10000;
        month = (fulldate % 10000) / 100;
        year = (fulldate % 100);

        // we dont parse the remaining, yet!
        return true;
    }

    return false;
}

bool RamaGNSS::newNMEAReceived()
{
    return receivedFlag;
}

char *RamaGNSS::lastNMEA()
{
    receivedFlag = false;
    return (char *)lastLine;
}

float RamaGNSS::googleReadable(float coordinate)
{
    float input = coordinate;
    int firstTwo = ((int)input)/100.0f;
    float nextTwo = input - (float)(firstTwo*100.0f);
    float finalConversion = (float)(firstTwo + nextTwo/60.0f);

    return finalConversion;
}

char RamaGNSS::readNMEA()
{
    char receivedChar = 0;

    if(!_gnss.readable()) return receivedChar;
    receivedChar = _gnss.getc();

    if (receivedChar == '$') {
        currentLine[lineIndex] = 0;
        lineIndex = 0;
    }

    if (receivedChar == '\n') {
        currentLine[lineIndex] = 0;

        if (currentLine == line01) {
            currentLine = line02;
            lastLine = line01;
        } else {
            currentLine = line01;
            lastLine = line02;
        }

        lineIndex = 0;
        receivedFlag = true;
    }

    currentLine[lineIndex++] = receivedChar;

    if (lineIndex >= MAX_LINE_SIZE)
        lineIndex = MAX_LINE_SIZE - 1;

    return receivedChar;
}