/*
Copyright (c) 2019 Flow design labs, Project RAMA R01

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "Other/DebuggerColors.h"

#ifndef MBED_RamaGNSS_H
#define MBED_RamaGNSS_H

#define MAX_LINE_SIZE 120

class RamaGNSS
{
public:
    RamaGNSS(Serial &gnss/*, Serial &debugger*/);

    float googleReadable(float coordinate);
    bool parseNMEA(char *nmeaSentence);
    bool newNMEAReceived();
    char readNMEA();
    char *lastNMEA();

    // time variables
    uint8_t hour;
    uint8_t minute;
    uint8_t seconds;
    uint8_t year;
    uint8_t month;
    uint8_t day;
    uint16_t milliseconds;
    
    // location variables
    float latitude;
    float longitude;
    float geoidHeight;
    float altitude;
    float speed;
    float angle;
    float HDOP;
    
    char headingLatitude;
    char headingLongitude;
    char satelliteFixValue;
    
    // satellite definitions
    bool isFixed;    
    
    uint8_t fixquality;
    uint8_t satelliteCount;

private:
    volatile char line01[MAX_LINE_SIZE];
    volatile char line02[MAX_LINE_SIZE];
    volatile char *currentLine;
    volatile char *lastLine;

    volatile uint16_t lineIndex;

    volatile bool receivedFlag;
    volatile bool inStandbyMode;
    bool paused;

    Serial &_gnss;
    //Serial &_debugger;
};

#endif