/*
        ___       ___       ___   
       /\  \     /\  \     /\  \
      /::\  \   /::\  \   /::\  \
     /:/\:\__\ /::\:\__\ /::\:\__\
     \:\ \/__/ \/\::/  / \/\::/  /
      \:\__\     /:/  /     \/__/ 
       \/__/     \/__/
                                    
    2016 Flow design labs, Project LEAF
    
    //////////////////////////////////////////////////////
    //  CAP12xx_SEN - Sensitivity values - 1x minimum   //
    //  0x0F    //128x sensitivity                      //
    //  0x1F    //64x  sensitivity                      //
    //  0x2F    //32x  sensitivity                      //
    //  0x3F    //16x  sensitivity                      //
    //  0x4F    //8x   sensitivity                      //
    //  0x5F    //4x   sensitivity                      //    
    //  0x6F    //2x   sensitivity                      //
    //  0x7F    //1x   sensitivity                      //
    //////////////////////////////////////////////////////
    
    * Example:
    * @code
    *    //I2C i2c(p1, p2); //SDA, SCL lines
    *    //InterruptIn interrupt(p24);
    *    CAP12xx touch_pad(i2c, interrupt);
    *    CAP12xx touch_pad(p1, p2, p3);
    *    uint8_t probe = 0;
    *   
    *    int main(){
    *      
    *        printf("\n\rInitializing CAP12xx\n\r");
    *       
    *        if (touch_pad.init()) {
    *            printf("OK - CAP12xx detected\n\r");
    *        } else {
    *           printf("ERROR - CAP12xx not found, check connection\n\r"); //Based on chip revision this can happen. Library uses 0x01 chip revision for identification
    *        }
    *        touch_pad.enable();
    *           
    *        while(1) {
    *            if (touch_pad.touched()){
    *                printf("Touched - %u\n\r", touch_pad.identify_probe_touched());
    *            }
    *        }
    *    }
    * @endcode
*/

#ifndef CAP12xx_H
#define CAP12xx_H

#include "mbed.h"
  
#define CAP12xx_MAIN    0x00   //Controls power states and indicates an interrupt
#define CAP12xx_MINT    0x1    //Clears interrupts on touch
#define CAP12xx_SEN     0x1F   //Controls the sensitivity of the threshold and delta counts and datascaling of the base counts 
#define CAP12xx_MTC     0x2A   //Determines the number of simultaneous touches to flag a multiple touch condition
#define CAP12xx_SIS     0x03   //Returns the state of the sampled capacitive touch sensor inputs
#define CAP12xx_PID     0xFD   //Stores a fixed value that identifies the CAP12xx
#define CAP12xx_MID     0xFE   //Stores a fixed value that identifies Microchip
#define CAP12xx_REV     0xFF   //Stores a fixed value that represents the revision number
#define CAP12xx_ACT     0x24   //Controls averaging and sampling window for Active
#define CAP12xx_CAL     0x26   //Forces calibration for capacitive touch sensor inputs and indicates calibration failure
#define CAP12xx_ENA     0x27   //Determines which capacitive sensor inputs can generate interrupts
#define CAP12xx_IRP     0x28   //Turn off interrupt repeat on button hold
#define CAP12xx_GRD     0x29   //Enables the signal guard for specific sensor inputs
#define CAP12xx_STB     0x41   //Controls averaging and sensing cycle time for Standby
#define CAP12xx_IRR     0x44   //Set interrupt on press but not release - default 0x41

class CAP12xx
{
    private:
        I2C communication;
        InterruptIn interrupt;
        uint8_t core_address;
        uint8_t probe;
        uint8_t probe_touched;
        void handler(void);
    
    public:
        CAP12xx(PinName SDA, PinName SCL, PinName interrupt_pin);
        bool init();
        void enable(void);
        void disable(void);
        uint8_t touched(void);
        uint8_t identifyProbeTouched(void);
        void setSensitivity(char level);
        void writeRegister(char address, char data);
        uint8_t readRegister(char address);
        uint8_t inspect(void);
};
    
#endif