
#include "mbed.h"
#include <stdio.h>
#include <errno.h>

// Block devices
#if COMPONENT_SPIF
#include "SPIFBlockDevice.h"
#endif

#if COMPONENT_DATAFLASH
#include "DataFlashBlockDevice.h"
#endif 

#if COMPONENT_SD
#include "SDBlockDevice.h"
#endif 

#include "HeapBlockDevice.h"

// File systems
#include "LittleFileSystem.h"
#include "FATFileSystem.h"
#include "stm32l475e_iot01_tsensor.h"

// Physical block device, can be any device that supports the BlockDevice API
/*SPIFBlockDevice bd(
        MBED_CONF_SPIF_DRIVER_SPI_MOSI,
        MBED_CONF_SPIF_DRIVER_SPI_MISO,
        MBED_CONF_SPIF_DRIVER_SPI_CLK,
        MBED_CONF_SPIF_DRIVER_SPI_CS);*/
        
InterruptIn button(USER_BUTTON);
Ticker toggle_led_ticker;

EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;

#define BLOCK_SIZE 512
HeapBlockDevice bd(16384, BLOCK_SIZE);

// File system declaration
LittleFileSystem fs("fs");

static FILE *f;
volatile int counter = 0;

void get_data_from_sensors() {
    float sensor_value=0;
    sensor_value = BSP_TSENSOR_ReadTemp();
    fprintf(f, "%f\n", sensor_value);
    fflush(f);
    fflush(stdout);
    printf("Saving temperature...\n");
}

void print_data_from_file() {
    fflush(stdout);
    fflush(f);
    fseek(f, 0, SEEK_SET);
    float value;
    while (!feof(f)) {
        fscanf(f, "%f", &value); 
        printf("%f\n", value);
    }
    fflush(stdout);
}

void toggle() {
    queue.call(print_data_from_file);
}

void toggle_led() {
    queue.call(get_data_from_sensors);
}

// Entry point for the example
int main() {
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    BSP_TSENSOR_Init();
    button.rise(&toggle);
    
    printf("--- Mbed OS filesystem example ---\n");

    // Try to mount the filesystem
    printf("Mounting the filesystem... ");
    fflush(stdout);
    int err = fs.mount(&bd);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("No filesystem found, formatting... ");
        fflush(stdout);
        err = fs.reformat(&bd);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }

    // Open the numbers file
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    f = fopen("/fs/numbers.txt", "r +");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        // Create the numbers file if it doesn't exist
        printf("No file found, creating a new file... ");
        fflush(stdout);
        f = fopen("/fs/numbers.txt", "w+");
        printf("%s\n", (!f ? "Fail :(" : "OK"));
        if (!f) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }

        printf("Seeking file... ");
        fflush(stdout);
        err = fseek(f, 0, SEEK_SET);
        printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
        if (err < 0) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
    }
    
    // Go through and record the acc
    toggle_led_ticker.attach(&toggle_led, 60);

}

