#include "mbed.h"
#define QUEUE_SIZE 5
Mutex mutex1;
Mutex mutex2;
ConditionVariable full(mutex1);
ConditionVariable empty(mutex2);
Thread producer;
Thread consumer;


typedef struct {
    uint8_t counter;   /* A counter value               */
} element_t;


MemoryPool<element_t, QUEUE_SIZE> mpool;
Queue<element_t, QUEUE_SIZE> queue;
volatile int in_queue_elements = 0;



void producer_thread(void) {
    while (1) {
      mutex1.lock();
      if (in_queue_elements == QUEUE_SIZE) {
        full.wait();    
      }
      element_t *element = mpool.alloc();
      element->counter = in_queue_elements+1; 
      queue.put(element);
      in_queue_elements++;
      printf("++There are %d elements in the queue\n", in_queue_elements);
      if (in_queue_elements == 1) {
        full.notify_all();
      }
      mutex1.unlock();
      if (rand() % 10 < 2) {
            wait(rand()%2);
    }
    }
}

void consumer_thread(void) {
    while (1) {
        mutex1.lock();
        if (in_queue_elements == 0) {
          full.wait();    
        }
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
          element_t *element = (element_t*)evt.value.p;
          printf("Got element: %u\n", element->counter);
          mpool.free(element);
          in_queue_elements--;
        }
        
        printf("--There are %d elements in the queue\n", in_queue_elements);
        if (in_queue_elements == QUEUE_SIZE-1) {
          full.notify_all();   
        }    
        mutex1.unlock();
        if (rand() % 10 < 2) {
            wait(rand()%2);
        }
    }
}

int main() {
    // Create a thread to execute the function led2_thread
    producer.start(producer_thread);
    consumer.start(consumer_thread);
    // Now led2_thread is executing concurrently with main at this point

}