#include "mbed.h"

DigitalOut led1(LED1);
InterruptIn button(USER_BUTTON);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;

volatile time_t first_seconds = 0;

void fall_handler_thread_context(void) {
    printf("rise_handler_thread_context in context %p\r\n", Thread::gettid());
    printf("firt_seconds: %d\n", first_seconds);
    time_t seconds = time(NULL);
    if (first_seconds != 0 && ((seconds - first_seconds) < 2)) {
            led1 = !led1;
    }
    printf("seconds: %d\n", seconds);
    first_seconds = seconds; 
}

void fall_handler_iterrupt_context(void) {
    // Execute the time critical part first
    
    // The rest can execute later in user context (and can contain code that's not interrupt safe)
    // We use the 'queue.call' function to add an event (the call to 'rise_handler_user_context') to the queue
    queue.call(fall_handler_thread_context);
}


int main() {
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Starting in context %p\r\n", Thread::gettid());
    // The 'rise' handler will execute in IRQ context
    button.fall(fall_handler_iterrupt_context);
    // button.rise(queue.event(rise_handler));
    // The 'fall' handler will execute in the context of thread 't'
}
