#pragma once
#ifndef __POWER_SERVICE_H__
#define __POWER_SERVICE_H__

#include "BLE.h"

class PowerService
{
    public:
        enum
        {
            UUID_POWER_SERVICE          = 0xA300,
            UUID_POWER_VOLTAGE_CHAR     = 0xA301,
            UUID_POWER_CURRENT_CHAR     = 0xA302,
            UUID_POWER_DISCHARGE_CHAR   = 0xA303
        };
    
        PowerService
        (
            BLE    &ble,
            float   initialVoltage = 0.0f,
            float   initialCurrent = 0.0f,
            float   initialDischarge = 0.0f
        ) :
            gattServer(ble.gattServer()),
            voltageCharacteristic
            (
                UUID_POWER_VOLTAGE_CHAR,
                (float*)&initialVoltage,
                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY
            ),
            currentCharacteristic
            (
                UUID_POWER_CURRENT_CHAR,
                (float*)&initialCurrent,
                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY
            ),
            dischargeCharacteristic
            (
                UUID_POWER_DISCHARGE_CHAR,
                (float*)&initialDischarge,
                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY
            )
        {
            static bool serviceAdded = false;
            if (serviceAdded)
                return;
                
            GattCharacteristic *charTable[] =
            {
                &voltageCharacteristic,
                &currentCharacteristic,
                &dischargeCharacteristic
            };
            
            GattService powerService(UUID_POWER_SERVICE, charTable, sizeof(charTable) / sizeof(GattCharacteristic*));
            
            gattServer.addService(powerService);
            
            serviceAdded = true;
        }
        
        void updateVoltage(float voltage)
        {
            gattServer.write(voltageCharacteristic.getValueHandle(), (uint8_t*)&voltage, sizeof(float));
        }
        
        void updateCurrent(float current)
        {
            gattServer.write(currentCharacteristic.getValueHandle(), (uint8_t*)&current, sizeof(float));
        }
        
        void updateDischarge(float discharge)
        {
            gattServer.write(dischargeCharacteristic.getValueHandle(), (uint8_t*)&discharge, sizeof(float));
        }
    
    private:
        GattServer                         &gattServer;
        ReadOnlyGattCharacteristic<float>   voltageCharacteristic;
        ReadOnlyGattCharacteristic<float>   currentCharacteristic;
        ReadOnlyGattCharacteristic<float>   dischargeCharacteristic;
};

#endif