#ifndef M95010_H
#define M95010_H

#include <stdint.h>
#include "mbed.h"

#define M95010_WRITE_ENABLE 0x06
#define M95010_WRITE_DISABLE 0x04
#define M95010_READ_STATUS 0x05
#define M95010_WRITE_STATUS 0x01
#define M95010_READ_MEMORY 0x03
#define M95010_WRITE_MEMORY 0x02

class M95010
{
public:
  M95010(SPI &_spi, PinName _ncs);

  bool isBusy();
  void writeEnable(bool val);
  void writeByte(uint8_t bank, uint8_t data);
  void writeBytes(uint8_t bank, uint8_t *arr, uint8_t count);
  uint8_t readByte(uint8_t bank);
  void readBytes(uint8_t bank, uint8_t *arr, uint8_t count);

private:
  SPI &spi;
  DigitalOut ncs;
  bool sensorPresent;
};

#endif
