#include "M95010.h"

M95010::M95010(SPI &_spi, PinName _ncs)
    : spi(_spi), ncs(_ncs, 1)
{
}

bool M95010::isBusy()
{
    ncs = 0;
    spi.write(M95010_READ_STATUS);
    volatile uint8_t status = spi.write(0x00);
    ncs = 1;

    return status & 0x01;
}

void M95010::writeEnable(bool val)
{
    ncs = 0;
    spi.write(val ? M95010_WRITE_ENABLE : M95010_WRITE_DISABLE);
    ncs = 1;
}

void M95010::writeByte(uint8_t bank, uint8_t data)
{
    uint8_t arr[1] = {data};
    writeBytes(bank, arr, 1);
}

void M95010::writeBytes(uint8_t bank, uint8_t *arr, uint8_t count)
{
    ncs = 0;
    spi.write(M95010_WRITE_MEMORY);
    spi.write(bank);

    for (int i = 0; i < count; i++)
    {
        spi.write(arr[i]);
    }

    ncs = 1;
}

uint8_t M95010::readByte(uint8_t bank)
{
    uint8_t arr[1] = {0};
    readBytes(bank, arr, 1);
    return arr[0];
}

void M95010::readBytes(uint8_t bank, uint8_t *arr, uint8_t count)
{
    ncs = 0;
    spi.write(M95010_READ_MEMORY);
    spi.write(bank);

    for (int i = 0; i < count; i++)
    {
        arr[i] = spi.write(0x00);
    }

    ncs = 1;
}
