#include "mbed.h"

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);
InterruptIn  SW1(p14);

enum nextState {ST_EIN=0, ST_AUS, ST_STATE2, ST_STATE3};
nextState state;

bool pressed = false;
 
void fall(void) { 
    wait_ms(20);
    pressed = true; 
}
 
bool CheckFlag()
{
    if( pressed ) { 
        pressed=false; 
        return true; 
    }
    return false;
}

void ST_Ein(){
    while(true) {
        Led1 = 1;
        if(CheckFlag()) {
            state = ST_AUS;
            return;
        }
    }
}
 
void ST_Aus(void){
    while(true) {
        Led1 = 0;
        if(CheckFlag()) {
            state = ST_EIN;
            return;
        }
    }
}
 
void ST_Error(){
    while(1) {
        Led3 = !Led3;
        wait_ms(200);
    }
}

void stateMachine()
{
    switch (state)
    {
    case ST_EIN: ST_Ein();
        break;
    case ST_AUS: ST_Aus();
        break;
    default: ST_Error();
        break;
    }
}

int main()
{
    printf("Hello STM\n");
    SW1.fall(&fall); //.rise(&rise);
    while(1) {
        stateMachine(); 
    }
}
