#include "mbed.h"

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);
InterruptIn  SW1(p14);
Timer T1;

enum nextState {ST_GREEN, ST_YELLOW, ST_RED, ST_REDYELLOW};
nextState state;

bool pressed = false;
 
void rise(void) { 
    wait_ms(20);
    pressed = true; 
}
 
bool CheckFlag()
{
    if( pressed ) { 
        pressed = false; 
        return true; 
    }
    return false;
}

void ST_Green(){
    T1.reset();
    while(true) {
        Led1 = 1;
        Led2 = 0;
        Led3 = 0;
        if(CheckFlag() || T1.read() >= 8) {
            state = ST_YELLOW;
            return;
        }
    }
}
 
void ST_Yellow(void){
    T1.reset();
    while(true) {
        Led1 = 0;
        Led2 = 1;
        if(CheckFlag() || T1.read() >= 2) {
            state = ST_RED;
            return;
        }
    }
}
 
void ST_Red(void){
    T1.reset();
    while(true) {
        Led2 = 0;
        Led3 = 1;
        if(CheckFlag() || T1.read() >= 8) {
            state = ST_REDYELLOW;
            return;
        }
    }
}

void ST_RedYellow(void){
    T1.reset();
    while(true) {
        Led3 = 1;
        Led2 = 1;
        if(CheckFlag() || T1.read() >= 2) {
            state = ST_GREEN;
            return;
        }
    }
}
 
void ST_Error(){
    while(1) {
        Led4 = !Led4;
        wait_ms(200);
    }
}

void stateMachine()
{
    switch (state)
    {
    case ST_GREEN: ST_Green();
        break;
    case ST_YELLOW: ST_Yellow();
        break;
    case ST_RED: ST_Red();
        break;
    case ST_REDYELLOW: ST_RedYellow();
        break;
    default: ST_Error();
        break;
    }
}

int main()
{
    printf("Ampelsteuerung wurde gestartet... \n");
    T1.start();
    SW1.rise(&rise); 
    while(1) {
        stateMachine(); 
    }
}
