#include "mbed.h"

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);
InterruptIn  SW1(p14);

enum nextState {ST_OFF, ST_SLOW, ST_FAST, ST_ON };
nextState state = ST_OFF;

bool pressed = false;

void fall(void) { 
    wait_ms(20);
    pressed = true; 
}

bool CheckFlag()
{
    if( pressed ) { 
        pressed=false; 
        return true; 
    }
    return false;
}

void ST_off(void){          //LED aus
    while(true) {
        Led1 = 0;
        if(CheckFlag()) {
            state = ST_SLOW;
            return;
        }
    }
}

void ST_slow(void){     //langsam Blinken
    while(true) {
        Led1 = !Led1;
        wait_ms(500);
        if(CheckFlag()) {
            state = ST_FAST;
            return;
        }
    }
}

void ST_fast(void){     //schnell Blinken
    while(true) {
        Led1 = !Led1;
        wait_ms(200);
        if(CheckFlag()) {
            state = ST_ON;
            return;
        }
    }
}

void ST_on(void){     //LED ein
    while(true) {
        Led1 = 1;
        if(CheckFlag()) {
            state = ST_OFF;
            return;
        }
    }
}

void ST_Error(){
    while(1) {
        Led3 = !Led3;
        wait_ms(200);
    }
}

void stateMachine()     //ST_OFF, ST_SLOW, ST_FAST, ST_ON
{
    switch (state)
    {
    case ST_OFF: ST_off();
        break;
    case ST_SLOW: ST_slow();
        break;
    case ST_FAST: ST_fast();
        break;
    case ST_ON: ST_on();
        break;
    default: ST_Error();
        break;
    }
}

int main()
{
    printf("Hello STM\n");
    SW1.fall(&fall); //.rise(&rise);
    while(1) {
        stateMachine(); 
    }
}
