#include "mbed.h"
//Programa motor paso a paso para motor de 200 pasos (Estándar)
// 1.8° por paso

Serial rs232(USBTX, USBRX);

BusOut step_secuence(PTA12, PTD4,  PTA1,  PTA2);
unsigned int num_pasos,grados,i,g,k;
int step;

void forward(int cont_pasos) // Avance motor
{
    k=0;
    for (i = 0; i<=cont_pasos; i++) {
        if (k>=4) {
            k=0;
        }
        switch (k) {
            case 0:
                step_secuence=0x0A;
                break;
            case 1:
                step_secuence=0x09;
                break;
            case 2:
                step_secuence=0x05;
                break;
            case 3:
                step_secuence=0x06;
                break;
        }
        ++k;
        wait(0.2);
    }
    g=g+8;
    grados=(g/num_pasos)*15;
    if(grados>=360) {
        g=0;
    }
    rs232.printf("%d \r\n",grados); //Visualiza avance cada 15°
}

void backward(int cont_pasos)   // Retroceso motor
{
    k=3;
    for (i = 0; i<=cont_pasos-1; i++) {
        if (k<=0) {
            k=3;
        }
        switch (k) {
            case 0:
                step=0x06;
                break;
            case 1:
                step=0x05;
                break;
            case 2:
                step=0x09;
                break;
            case 3:
                step=0x0A;
                break;
        }
        wait(0.2);
        --k;
    }
}


int main()
{
    rs232.baud(9600);
    g=0;
    num_pasos=8; // 1.8° por paso son 8.3333 pasos para avanzar 15°, se aproxima a 8
    while(1) {
        forward(num_pasos); // Avance 8 pasos = 15°
    }
}
