#include "mbed.h"

InterruptIn sensor1(PTA2); // Pines de Interrupción según hoja técnica
InterruptIn sensor2(PTA1);
InterruptIn sensor3(PTA4);
InterruptIn sensor4(PTA12);
DigitalOut led_r(LED1);
DigitalOut led_g(LED2);
DigitalOut led_b(LED3);

Serial rs232(USBTX, USBRX);

void ISR1()
{
    rs232.printf("sensor 1 activo");
    led_r= !led_r;
    wait(1);
}

void ISR2()
{
    rs232.printf("sensor 2 activo");
    led_g = !led_g;
    wait(1);
}

void ISR3()
{
    rs232.printf("sensor 3 activo");
    led_b= !led_b;
    wait(1);
}

void ISR4()
{
    rs232.printf("sensor 4 activo");
    led_r = !led_r;
    led_g = !led_g;
    led_b = !led_b;
    wait(1);
}

int main()
{
    rs232.baud(9600);
    sensor1.mode(PullUp);
    sensor2.mode(PullUp);
    sensor3.mode(PullUp);
    sensor4.mode(PullUp);
    sensor1.rise(&ISR1);
    sensor2.rise(&ISR2);
    sensor3.rise(&ISR3);
    sensor4.rise(&ISR4);
    while(1) {
        wait(0.1);
    }
}

