#include "mbed.h"
#include "TextLCD.h" 
#include "Keypad.h"
 
Serial rs232(USBTX, USBRX);
AnalogIn Ain(PTB0); 

float ADCdata;

// Define your own keypad values
char Keytable[] = { '1', '2', '3', 'A',   // r0
                    '4', '5', '6', 'B',   // r1
                    '7', '8', '9', 'C',   // r2
                    '*', '0', '#', 'D'    // r3
                  }; // c0   c1   c2   c3
 
int32_t       Index = -1;

TextLCD lcd(PTE20,PTE21,PTE22,PTE23,PTE29,PTE30, TextLCD::LCD16x2); // Rs, E, d4, d5, d6, d7 
 
uint32_t cbAfterInput(uint32_t _index)
{
    Index = _index;
    return 0;
}
 

 
int main()
{   
    //             r0    r1     r2    r3     c0    c1      c2     c3
    Keypad keypad(PTA2, PTA1,  PTD4,  PTA12, PTA4, PTA5,  PTC8,  PTC9);
    keypad.attach(&cbAfterInput);
    keypad.start();  // energiza columnas c0-c3 del keypad
    
    rs232.printf("Temperatura ADC \n\r");
    lcd.printf("Temperatura ADC \r\n");
    wait(1);
    lcd.cls();
    lcd.locate(0,0);
 
    while (1) {
        //ADCdata=Ain;
        //rs232.printf("%f \n\r",ADCdata);
        //rs232.baud (115200);
        //rs232.format(8, Serial::Even, 1);
        rs232.printf(" %f ",Ain.read()*5);
        wait(.1);
        __wfi();
        if (Index > -1) {
            lcd.printf("Key:%c\r\n",Keytable[Index]);
            Index = -1;
        }
        wait(0.5);
    }
}