#include "mbed.h"

DigitalOut led(LED1);
Serial pc(USBTX, USBRX); // tx, rx
I2CSlave slave(PTC9,PTC8); // SDA, SCL

const int SLAVE_ADDRESS = 0x0A;
const int I2C_FREQUENCY = 100000;
// const int I2C_BUFFER_SIZE = 6;


int main() {
    pc.baud(9600);
    
    // Configure I2C
    slave.frequency(I2C_FREQUENCY);
    pc.printf("Frecuencia I2C Slave @ %dHz\r\n", I2C_FREQUENCY);
    slave.address(SLAVE_ADDRESS);
    pc.printf("Direccion Slave @ SLAVE_ADDRESS = 0x%x\r\n", SLAVE_ADDRESS);

    // I2C buffer
    // char buffer[I2C_BUFFER_SIZE];
       
    while (1) {
        int rec = slave.receive();
        pc.printf("Dato recibido %d\r\n", rec); 
    }
}