#include "mbed.h"
#include "TextLCD.h"
#include "Keypad.h"

Serial rs232(USBTX, USBRX);
AnalogIn AnalogPin(PTB0);
DigitalOut pinOut(PTB1);

TextLCD lcd(PTE20,PTE21,PTE22,PTE23,PTE29,PTE30, TextLCD::LCD16x2); // Rs, E, d4, d5, d6, d7, RW=GND
Keypad keypad(PTC4,PTC3,PTC0,PTC7,PTC11,PTC10,PTC6,PTC5); // c1, c2, c3, c4, f1, f2, f3, f4

char key;
int released=1,unidades,decenas,centenas;
float setpoint,valor_adc;

void read_kpad()
{
    key=keypad.ReadKey();
    if(key=='\0') released=1;
    if((key!='\0') && (released==1)) {
        released=0;
    }

}

void setup_pyrom()
{
      int i=0;
      lcd.cls();
      lcd.locate(1,1);
      lcd.printf("SETUP...");
      wait(1);
      lcd.cls();
      while(i<=2){
      read_kpad();
      if(key!='\0'){ 
         if(i==0){centenas=key-48;lcd.locate(1,1);lcd.printf("%c",key);if(centenas>1){centenas=1;}}
         if(i==1){decenas=key-48;lcd.locate(2,1);lcd.printf("%c",key);}
         if(i==2){unidades=key-48;lcd.locate(3,1);lcd.printf("%c",key);}
          ++i;}
      }
         wait(0.25);
         setpoint=unidades+10.0*decenas+100.0*centenas;
         lcd.cls();
         lcd.locate(1,1);
         lcd.printf("SP: %fdegC    ",setpoint);
         wait(1);
         lcd.cls();
         lcd.locate(1,1);
         lcd.printf("SETUP OK");
         wait(1);
}




int main()
{

    rs232.printf("Control ON-OFF \n\r");
    lcd.printf("Control ON-OFF \r\n");
    wait(1);
    lcd.cls();

    while (1) {
        valor_adc=AnalogPin.read()*5;
        lcd.locate(1,1);
        lcd.printf("SP; %fdegC ",setpoint);
        lcd.locate(1,2);
        lcd.printf("PV; %fdegC ",valor_adc);
        rs232.printf("%f,%f",setpoint,valor_adc);
        
        read_kpad();
        if(key=='*') {
            setup_pyrom();
        }

        if(valor_adc>=setpoint) {
            pinOut=0;
        } else {
            pinOut=1;;
        }


    }
}