#include "mbed.h"

Serial rs232(USBTX, USBRX); //enable serial port which links to USB
Timer Timer1;
DigitalOut led1(LED1);
InterruptIn s0(PTA13);
DigitalIn s1(PTC8);
DigitalIn s2(PTC9);
DigitalIn s3(PTD5);
DigitalIn s4(PTD0);
InterruptIn  s5(PTD2);
InterruptIn int1(PTD0);

unsigned int contador = 0, frec = 0, cont_color1, cont_color2, cont_color3;
bool flag_color1, flag_color2, flag_color3, conveyor_on;

int num_pasos,grados,i,g,k,step,desplazam,origen, destino;
BusOut step_secuence1(PTD4,PTA12,PTA4,PTA5);
BusOut step_secuence2(PTD7,PTA6,PTE31,PTA17);


void conveyor_step() // Avance motor
{
    k=0;
    for (i = 0; i<=8; ++i) {
        switch (k) {
            case 0:
                step_secuence2=0x0A;
                break;
            case 1:
                step_secuence2=0x09;
                break;
            case 2:
                step_secuence2=0x05;
                break;
            case 3:
                step_secuence2=0x06;
                break;
            default:
                break;
        }
        ++k;
        if (k>=4) {
            k=0;
        }
        wait(0.1);
    }
    rs232.printf("Banda On\r\n"); //Enciende Banda
}

void forward(int cont_pasos) // Avance motor
{
    k=0;
    for (i = 0; i<=cont_pasos; ++i) {
        switch (k) {
            case 0:
                step_secuence1=0x0A;
                break;
            case 1:
                step_secuence1=0x09;
                break;
            case 2:
                step_secuence1=0x05;
                break;
            case 3:
                step_secuence1=0x06;
                break;
            default:
                break;
        }
        ++k;
        if (k>=4) {
            k=0;
        }
        wait(0.1);
    }
    g=g+8;
    grados=(g/num_pasos)*15;
    if(grados>360) {
        g=0;
        grados=0;
    }
    rs232.printf("%d\r\n",grados); //Visualiza avance cada 15°
}


void backward(int cont_pasos)   // Retroceso motor
{
    k=3;
    for (i = 0; i<=cont_pasos-1; i++) {
        if (k<=0) {
            k=3;
        }
        switch (k) {
            case 0:
                step_secuence1=0x06;
                break;
            case 1:
                step_secuence1=0x05;
                break;
            case 2:
                step_secuence1=0x09;
                break;
            case 3:
                step_secuence1=0x0A;
                break;
        }
        wait(0.1);
        --k;
    }
    g=g-8;
    if(grados<0) {
        g=192;
    }
    grados=(g/num_pasos)*15;
    if(grados<0) {
        grados=360;
    }
    rs232.printf("%d\r\n",grados); //Visualiza retroceso cada 15°
}

void ISR_PTD0()
{
    ++contador;
}

void ISR_S0()
{
    conveyor_on=1;
}

void ISR_S5()
{
    conveyor_on=0;
}

void frecuencia()
{
    contador=0;
    Timer1.start();
    while(Timer1.read_ms()<=10);
    Timer1.stop();
    frec=100*(contador);
    Timer1.reset();
}

int main()
{
    rs232.baud(9600);
    g=0;
    num_pasos=8; // 1.8° por paso son 8.3333 pasos para avanzar 15°, se aproxima a 8
    grados=0;
    origen=1;
    conveyor_on=0;
    int1.mode(PullUp);
    int1.rise(&ISR_PTD0);
    s0.mode(PullUp);
    s0.rise(&ISR_S0);
    s5.mode(PullUp);
    s5.rise(&ISR_S5);
    while(true) {
        if(conveyor_on==1) {
            conveyor_step();
        }
        frecuencia();
        rs232.printf("f=%d Hz\r\n",frec);
        if(frec>=10000 && frec<=15000) {
            rs232.printf("f=%d Hz\r\n",frec);
            if(flag_color1==0) {
                ++cont_color1;
                rs232.printf("Rosado");
                if(destino>origen) {
                    desplazam=destino-origen;
                    switch(desplazam) {
                        case 1:
                            forward(48);
                            break;
                        case 2:
                            forward(96);
                            break;
                        case 3:
                            forward(144);
                            break;
                    }
                }
                if(destino<origen) {
                    desplazam=origen-destino;
                    switch(desplazam) {
                        case 1:
                            forward(144);
                            break;
                        case 2:
                            forward(96);
                            break;
                        case 3:
                            forward(48);
                            break;
                    }
                }
                //origen=destino;
                if(s1==0) {
                    desplazam=origen-destino;
                    switch(desplazam) {
                        case 1:
                            forward(144);
                            break;
                        case 2:
                            forward(96);
                            break;
                        case 3:
                            forward(48);
                            break;
                    }
                }
            }
            flag_color1=1;
        } else {
            flag_color1=0;
        }
        if(frec>=20000 && frec<=25000) {
            rs232.printf("f=%d Hz\r\n",frec);
            if(flag_color1==0) {
                ++cont_color2;
                rs232.printf("Dorado");
                if(destino>origen) {
                    desplazam=destino-origen;
                    switch(desplazam) {
                        case 1:
                            forward(48);
                            break;
                        case 2:
                            forward(96);
                            break;
                        case 3:
                            forward(144);
                            break;
                    }
                }
                if(destino<origen) {
                    desplazam=origen-destino;
                    switch(desplazam) {
                        case 1:
                            forward(144);
                            break;
                        case 2:
                            forward(96);
                            break;
                        case 3:
                            forward(48);
                            break;
                    }
                }
                origen=destino;
            }
            flag_color2=1;
        } else {
            flag_color2=0;
        }
        if(frec>=30000 && frec<=35000) {
            rs232.printf("f=%d Hz\r\n",frec);
            if(flag_color1==0) {
                ++cont_color3;
                rs232.printf("Fucsia");
                if(destino>origen) {
                    desplazam=destino-origen;
                    switch(desplazam) {
                        case 1:
                            forward(48);
                            break;
                        case 2:
                            forward(96);
                            break;
                        case 3:
                            forward(144);
                            break;
                    }
                }
                if(destino<origen) {
                    desplazam=origen-destino;
                    switch(desplazam) {
                        case 1:
                            forward(144);
                            break;
                        case 2:
                            forward(96);
                            break;
                        case 3:
                            forward(48);
                            break;
                    }
                }
                origen=destino;
            }
            flag_color3=1;
        } else {
            flag_color3=0;
        }
        wait(0.5);
    }
}






