#include "mbed.h"
#include "Adafruit_SSD1306.h"
#define SDA PTE0
#define SCL PTE1

class I2C2 : public I2C
{
public:
    I2C2(PinName sda, PinName scl) : I2C(sda, scl) {
        frequency(400000);
        start();
    };
};


DigitalOut ledRed(LED1);
DigitalOut ledGreen(LED2);

I2C2 gI2C(SDA,SCL);
Adafruit_SSD1306_I2c gOled2(gI2C, NC, 0x78, 64, 128);


int main()
{
    uint16_t x = 0;
    gOled2.clearDisplay();
    gOled2.display();
    //gOled2.setTextCursor(1, 0);
    gOled2.printf("%ux%u UDistrital r\n", gOled2.width(), gOled2.height());

    while (1) {
        ledRed = !ledRed;
        gOled2.setTextCursor(0, 10);
        gOled2.printf("%u\r", x);
        gOled2.display();
        x++;
        wait(1.0);
    }
}
