#include "mbed.h"

InterruptIn s0(PTA13); // Pines de Interrupción según hoja técnica
InterruptIn s1(PTD2);
InterruptIn s2(PTA4);
InterruptIn s3(PTA12);
DigitalOut led_r(LED1);
DigitalOut led_g(LED2);
DigitalOut led_b(LED3);


void ISR1()
{
    led_r= !led_r;
    wait(1);
}

void ISR2()
{
    led_g = !led_g;
    wait(1);
}

void ISR3()
{
    led_b= !led_b;
    wait(1);
}

void ISR4()
{
    led_r = !led_r;
    led_g = !led_g;
    led_b = !led_b;
    wait(1);
}

int main()
{
    s0.mode(PullUp);
    s1.mode(PullUp);
    s2.mode(PullUp);
    s3.mode(PullUp);
    s0.rise(&ISR1);
    s1.rise(&ISR2);
    s2.rise(&ISR3);
    s3.rise(&ISR4);
    while(1) {
        wait(0.1);
    }
}


