/**************************************************************************************************************
 *****                                                                                                    *****
 *****  Name: rgb2hsi.h                                                                                   *****
 *****  Date: 12/04/2015                                                                                  *****
 *****  Auth: Frank Vannieuwkerke                                                                         *****
 *****  Func: convert RGB color space values to HSI                                                       *****
 *****                                                                                                    *****
 *****  Source : http://www.had2know.com/technology/hsi-rgb-color-converter-equations.html                *****
 *****                                                                                                    *****
 **************************************************************************************************************/

#ifndef RGB2HSI_H
#define RGB2HSI_H

/** Convert RGB to HSI.
*
* @param rgb         Input - Pointer to RGB array[3] (uint8_t  0..255).\n
*                    rgb[0] = red, rgb[1] = green, rgb[2] = blue.\n
* @param Hue         Output - Pointer to Hue (float 0..360)\n
* @param Saturation  Output - Pointer to Saturation (float 0..1)\n
* @param Intensity   Output - Pointer to Intensity (float 0..1)\n
*
*/
void rgb2hsi (uint8_t *rgb, float *Hue, float *Saturation, float *Intensity)
{
    float red = (float)rgb[0];
    float green = (float)rgb[1];
    float blue = (float)rgb[2];
    *Intensity = (red + green + blue)/3;
    if(*Intensity == 0) {
        *Saturation = 0;
    } else {
        *Saturation = 1 - min(red,min(green,blue))/(*Intensity);
    }

    if((red == green) && (red == blue)) {
        *Hue = 0;
    } else {
        *Hue = acos((red - (green/2) - (blue/2)) / sqrt((red*red) + (green*green) + (blue*blue) - (red*green) - (red*blue) - (green*blue)));
        *Hue = *Hue * 180.0f / 3.14159265f;
        if(blue > green)
            *Hue = 360.0f - (*Hue);
    }
    *Hue = floor((*Hue)+0.5);
    *Intensity = floor((*Intensity)+0.5f)/255;
    *Saturation = floor(((*Saturation)*10000)+0.5f)/10000;
}

#endif
