#ifndef _WIGO_BATTCHARGER_H_
#define _WIGO_BATTCHARGER_H_

#include "mbed.h"

//Battery Circuit for Avnet PCB
#define CHRG_EN1        PTB2
#define CHRG_EN2        PTB3
#define CHRG_SNS_EN     PTC2
#define CHRG_SNS        PTB1
#define CHRG_POK        PTC6
#define CHRG_CHG        PTA5
#define POWER_OK        0
#define CHARGING        0
#define BATT_LED_ON     0
#define BATT_LED_OFF    1
#define BATT_0          0.53
#define BATT_100        0.63
#define CHRG_100MA      0
#define CHRG_500MA      1
#define CHRG_740MA      2
#define CHRG_STOP       3

class WiGo_BattCharger
{
public:

    WiGo_BattCharger( PinName en1, PinName en2, PinName snsen, PinName sense,
                      PinName supplystate, PinName chargestate );

    void init( int n );

    void sense_en( int n);

    unsigned short readRaw( void );

    float read( void );

    int charging( void );

    int supply( void );

    int level( void );
    
protected:
    DigitalOut _en1;
    DigitalOut _en2;
    DigitalOut _snsen;
    AnalogIn   _sense;
    DigitalIn  _supplystate;
    DigitalIn  _chargestate;
};

#endif
