#ifndef RUN_EXOSITE_H
#define RUN_EXOSITE_H

#include "TCPSocketConnection.h"
#include "TCPSocketServer.h"

extern cc3000 wifi;
extern tUserFS user_info;

#ifdef    __cplusplus
extern "C" {
#endif

#include <stdint.h>

void run_exosite(TCPSocketConnection *socket);

// defines
enum UUIDInterfaceTypes
{
    IF_WIFI,
    IF_ENET,
    IF_FILE,
    IF_HDD,
    IF_I2C,
    IF_GPRS,
    IF_NONE
};

enum ExositeStatusCodes
{
    EXO_STATUS_OK,
    EXO_STATUS_INIT,
    EXO_STATUS_BAD_UUID,
    EXO_STATUS_BAD_VENDOR,
    EXO_STATUS_BAD_MODEL,
    EXO_STATUS_BAD_INIT,
    EXO_STATUS_BAD_TCP,
    EXO_STATUS_BAD_SN,
    EXO_STATUS_CONFLICT,
    EXO_STATUS_BAD_CIK,
    EXO_STATUS_NOAUTH,
    EXO_STATUS_END
};

#define EXOSITE_VENDOR_MAXLENGTH                20
#define EXOSITE_MODEL_MAXLENGTH                 20
#define EXOSITE_SN_MAXLENGTH                    EXOSITE_HAL_SN_MAXLENGTH
#define EXOSITE_DEMO_UPDATE_INTERVAL            4000// ms
#define CIK_LENGTH                              40

// --------------   META   --------------
// defines
#define META_SIZE                 256
#define META_CIK_SIZE             40
#define META_SERVER_SIZE          6
#define META_PAD0_SIZE            2
#define META_MARK_SIZE            8
#define META_UUID_SIZE            17
#define META_PAD1_SIZE            4
#define META_RSVD_SIZE            56
#define META_MFR_SIZE             128
typedef struct {
  char cik[META_CIK_SIZE];                   // our client interface key
  char server[META_SERVER_SIZE];             // ip address of m2.exosite.com (not using DNS at this stage)
  char pad0[META_PAD0_SIZE];                 // pad 'server' to 8 bytes
  char mark[META_MARK_SIZE];                 // watermark
  char uuid[META_UUID_SIZE];                 // UUID in ascii
  char pad1[META_PAD1_SIZE];                 // pad 'uuid' to 16 bytes
  char rsvd[META_RSVD_SIZE];                 // reserved space - pad to ensure mfr is at end of RDK_META_SIZE
  char mfr[META_MFR_SIZE];                   // manufacturer data structure
} exosite_meta;

#define EXOMARK "exosite!"

typedef enum
{
    META_CIK,
    META_SERVER,
    META_MARK,
    META_UUID,
    META_MFR,
    META_NONE
} MetaElements;


// --------------   HAL   --------------
// defines
/*typedef enum
{
    IF_WIFI,
    IF_ENET,
    IF_FILE,
    IF_HDD,
    IF_I2C,
    IF_NONE
} UUIDInterfaceTypes;*/

typedef enum
{
    EXO_ERROR_WRITE,
    EXO_ERROR_READ,
    EXO_ERROR_CONNECT,
    EXO_ERROR_UNKNOWN,
    EXO_ERROR_END
} ExositeErrorCodes;

typedef enum
{
    EXO_SERVER_CONNECTED,
    EXO_CLIENT_RW,
    EXO_UI_END
} ExositeUICodes;

#ifdef    __cplusplus
}
#endif // __cplusplus

#endif // RUN_EXOSITE_H

