/****************************************************************************
*
*  doTCPIP.cpp - CC3000 TCP/IP
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/

#include "mbed.h"
#include "defLED.h"
#include "doTCPIP.h"
#include "Wi-Go_eCompass_Lib_V3.h"

extern DigitalOut ledr;
extern DigitalOut ledg;
extern DigitalOut ledb;
extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;

extern int do_mDNS;
extern axis6_t axis6;
extern unsigned char newData;
extern int HsecondFlag;
extern unsigned int seconds;

// Setup the functions to handle our CGI parameters
extern char requestBuffer[];
  
//Device name - used for Smart config in order to stop the Smart phone configuration process
extern char DevServname;

void runTCPIPserver(void)
{
    while(1)
    {
        long temp, stat, sss, skip, skipc, newsock;
        LED_D3_OFF;
        LED_D2_OFF;
        printf("\n\nStarting TCP/IP Server\n");
        TCPSocketServer server;
        server.bind(TCPIP_PORT);
        server.listen();
        printf("\r\nWait for new connection...\r\n");
        skip = 0;
        skipc = 0;
        while(1)
        {
            newsock = -2;
            printf("\r\nServer waiting for connection\r\n");
            TCPSocketConnection client;
            LED_D2_ON;
            while((newsock == -1) || (newsock == -2))
            {
                newsock = server.accept(client);
                client.set_blocking(true);
                if(do_mDNS)
                {
                    printf("mDNS= 0x%08x\n", wifi._socket.mdns_advertiser(1, (uint8_t *)DevServname, sizeof(DevServname)));
                    do_mDNS = 0;
                }
            }
            printf("Connection from: %s \r\n", client.get_address());
            sss = seconds;
            //receive TCP data
            temp = 0;   
            if(newsock >= 0)
            {
                client.receive((char *)requestBuffer,20);
                printf("Input = %s\n", requestBuffer);
                HsecondFlag = 0;
                while(1)
                {
                    while(!newData) __wfi();
                    newData = 0;
                    if(HsecondFlag)
                    {
                        printf("FB= %d\n", wifi._simple_link.get_number_free_buffers());
                        HsecondFlag = 0;
                    }
                    LED_D2_ON;  
                    stat = -2;
                    stat = client.send_all((char *)&axis6, sizeof(axis6));
                    LED_D2_OFF;
                    if(stat != 96)
                    {
                        if(stat == -2)
                        {
                            skip++;
                            skipc++;
                        }
                        if(stat == -1) break;
                    }
                    else
                    {
                        temp++;
                        skipc = 0;
                    }
                    if(skipc > 150)
                    {
                        printf("Zero Buffer Error Sent=%d, time=%d\n", temp, seconds - sss);
                        break;
                    }
                }   
            } else printf("bad socket= %d\n", newsock);
            client.close();
            printf("Done %d, time= %d, skipped= %d\n", temp, seconds - sss, skip);
            skip = 0;
        }
    }   
}
