/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
 
#ifndef MPL3115A2_H
#define MPL3115A2_H

#include "mbed.h"

// Oversampling value and minimum time between sample
#define OVERSAMPLE_RATIO_1      0       // 6 ms
#define OVERSAMPLE_RATIO_2      1       // 10 ms
#define OVERSAMPLE_RATIO_4      2       // 18 ms
#define OVERSAMPLE_RATIO_8      3       // 34 ms
#define OVERSAMPLE_RATIO_16     4       // 66 ms
#define OVERSAMPLE_RATIO_32     5       // 130 ms
#define OVERSAMPLE_RATIO_64     6       // 258 ms
#define OVERSAMPLE_RATIO_128    7       // 512 ms

/* Mode */
#define ALTIMETER_MODE      1
#define BAROMETRIC_MODE     2

class MPL3115A2
{
public:
    /**
    * MPL3115A2 constructor
    *
    * @param sda SDA pin
    * @param sdl SCL pin
    * @param addr addr of the I2C peripheral
    */
    MPL3115A2(PinName sda, PinName scl, int addr);
    
    /**
    * Get the altimeter value in raw mode
    *
    * @param    dt      pointer to unsigned char array
    * @returns 1 if data are available, 0 if not.
    */
    uint8_t getAltimeterRaw( unsigned char *dt);

    /**
    * Get the temperature value in raw mode
    *
    * @param    dt      pointer to unsigned char array
    * @returns 1 if data are available, 0 if not.
    */
    uint8_t getTemperatureRaw( unsigned char *dt);
    
    /** 
    * Return if there are date available
    * 
    * @return 0 for no data available, bit0 set for Temp data available, bit1 set for Press/Alti data available
    *         bit2 set for both Temp and Press/Alti data available
    */
    uint8_t isDataAvailable( void);

private:
    I2C m_i2c;
    int m_addr;
    void readRegs(int addr, uint8_t * data, int len);
    void writeRegs(uint8_t * data, int len);
};

#endif
