/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "MAG3110.h"

/******************************************************************************
 * Constructors
 ******************************************************************************/

MAG3110::MAG3110(PinName sda, PinName scl, int addr): m_i2c(sda, scl),  m_addr(addr)
{
    m_i2c.frequency(375000);
    unsigned char data[2] = {MAG_CTRL_REG2, MAG_3110_AUTO_MRST_EN};
    writeRegs(data, 2);
    data[0] = MAG_CTRL_REG1;
    data[1] = MAG_3110_ACTIVE;
    writeRegs(data, 2);
}

uint8_t MAG3110::isDataAvailable(void)
{
    uint8_t status;
    status = readReg(MAG_DR_STATUS);
    return (status & 0x07);
}

void MAG3110::readXYZ(uint8_t * data)
{
    char t[1] = {MAG_OUT_X_MSB};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, 6);
}

uint8_t MAG3110::readReg(uint8_t addr) {
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, t, 1);
    return t[0];
}

void MAG3110::writeRegs(uint8_t * data, int len) {
    m_i2c.write(m_addr, (char *)data, len);
}



