/*****************************************************************************
*
*  demo.c - CC3000 Main Demo Application
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/

#include "doTCPIP.h"
#include "run_exosite.h"
#include "exosite.h"

// local defines
#define WRITE_INTERVAL 5
#define EXO_BUFFER_SIZE 300 //reserve 300 bytes for our output buffer

typedef struct
{
    float *p;
    char *s;
} exo_data_ft;

typedef struct
{
    int16 *p;
    char *s;
} exo_data_it;

extern char requestBuffer[];

extern uint32 compass_type, seconds;
extern void init_eCompass(void);
extern void print_mac(void);
extern int LAN_Connected;


// local functions
extern unsigned char checkWiFiConnected(void);

extern userFS_t userFS;

// exported functions

// externs
extern const char sensorNames[10][11];
extern int Exosite_Write(char * pbuf, unsigned char buflen);
extern int Exosite_Read(char * palias, char * pbuf, unsigned char buflen);
extern int Exosite_Init(void);
extern int Exosite_ReInit(void);
extern char *itoa(int n, char *s, int b);
extern void busyWait(unsigned short delay);
extern void board_init(void);

extern axis6_t axis6;
extern int secondFlag;

// global variables
int cloud_status = -1;

/** \brief Flag indicating whether user requested to perform Smart Config */
extern char runSmartConfig;
//Flag to indicate Smart Config needs to be performed
extern unsigned char ptrFtcAtStartup;
//Flag to indicate Smart Config was performed in the past and CC3000 has a stored profile
extern unsigned char SmartConfigProfilestored;
extern unsigned char ConnectUsingSmartConfig; 

extern unsigned long ulCC3000Connected;
extern unsigned long SendmDNSAdvertisment;

extern void initTCPIP(void);

long serverSocket;
sockaddr serverSocketAddr;

/** \brief Definition of data packet to be sent by server */
unsigned char dataPacket[] = { '\r', 0xBE, 128, 128, 128, 70, 36, 0xEF };
char activeCIK[41];
char serverErrorCode = 0;

exo_data_ft exo_fdata[] = {
        &axis6.fGax,    "acc_x=%f&",
        &axis6.fGay,    "acc_y=%f&",
        &axis6.fGaz,    "acc_z=%f&",
        &axis6.fUTmx,   "mag_x=%f&",
        &axis6.fUTmy,   "mag_y=%f&",
        &axis6.fUTmz,   "mag_z=%f&",    
        &axis6.q0,      "q_w=%f&",  
        &axis6.q1,      "q_x=%f&",  
        &axis6.q2,      "q_y=%f&",  
        &axis6.q3,      "q_z=%f&",  
        0, 0 };

exo_data_it exo_idata[] = {
        &axis6.roll,    "roll=%d&",
        &axis6.pitch,   "pitch=%d&",
        &axis6.yaw,     "yaw=%d&",
        &axis6.alt,     "alt=%d&",
        &axis6.temp,    "temp=%d&",
        &axis6.light,   "light=%d&",
        0, 0
};
    
void setCIK(void)
{
    int i;
    for(i=0 ;i < CIK_LENGTH ; i++) activeCIK[i] = userFS.CIK[i];
    activeCIK[i] = NULL;
}

void build_str(void)
{
    exo_data_it *tsp;
    exo_data_ft *tspf;
    requestBuffer[0] = 0;
    tsp     = &exo_idata[0];
    tspf    = &exo_fdata[0];
    while(tsp->p)
    {
        sprintf( requestBuffer + strlen(requestBuffer), tsp->s, *tsp->p);
        tsp++;
    }
    while(tspf->p)
    {
        sprintf( requestBuffer + strlen(requestBuffer), tspf->s, *tspf->p);
        tspf++;
    }
    sprintf( requestBuffer + strlen(requestBuffer), "time=%d\r\n", axis6.timestamp);
}

//*****************************************************************************
//
//!  main
//!
//!  \param  None
//!
//!  \return none
//!
//!  \brief   The main loop is executed here
//
//*****************************************************************************
void run_exosite(void)
{
    int value;
    
    ulCC3000Connected = 0;
    SendmDNSAdvertisment = 0;
    printf("\nConnecting to Exosite\n");
    initTCPIP();
    //userFS.validCIK = 0; // uncomment this to force provisioning every time, only used for debug
    
    if(!userFS.validCIK)
    {
        printf("Activating Wi-Go System on Exosite\n");
        print_mac();
        wait_ms(100);
        printf("Enter the device MAC on your Exosite device portal to prepare\n");
        wait_ms(100);
        printf("the system for provisioning your Wi-Go system onto Exosite\n");
        wait_ms(100);
        printf("Hit any key to continue.....\n");
        getchar();
        Exosite_Init();
    }
    
    setCIK();
    // Main Loop
    while (1)
    {
        while(!secondFlag) /*__wfi()*/;
        secondFlag = 0;
        LED_D2_ON;
        build_str();   
        if(strlen(requestBuffer) > 300) printf("Buffer size= %d too small!!!", strlen(requestBuffer));
        //printf("Buffer size= %d\n", strlen(requestBuffer));
        value = Exosite_Write(requestBuffer,strlen(requestBuffer));    //write all sensor values to the cloud
        LED_D2_OFF; 
        if(value == -1)
        {
            LAN_Connected = 0;
            LED_D3_OFF;
            wlan_stop();
            initTCPIP();
        }
   }
}

