#include "mbed.h"
#include "doTCPIP.h"
#include "I2C_busreset.h"
#include "TSISensor.h"
#include "TEMT6200.h"
#include "WiGo_BattCharger.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "MPL3115A2.h"
#include "demo.h"
#include "run_exosite.h"

#define FCOUNTSPERG  4096.0F // sensor specific: MMA8451 provide 4096 counts / g in 2g mode
#define FCOUNTSPERUT   10.0F // sensor specific: MAG3110 provide 10 counts / uT

#define BATT_0          0.53
#define BATT_100        0.63

// Serial USB port
Serial pc(USBTX, USBRX);

// Slide sensor
TSISensor tsi;

// Systick
Ticker systick;

// Ambient light sensor : PTD5 = enable, PTB0 = analog input
TEMT6200 ambi(PTD5, PTB0);

//Wi-Go battery charger control
WiGo_BattCharger Batt(CHRG_EN1, CHRG_EN2, CHRG_SNS_EN, CHRG_SNS, CHRG_POK, CHRG_CHG);

// Accelerometer
#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

// Magnetometer
#define MAG3110_I2C_ADDRESS (0x0e<<1)
MAG3110 mag(PTE0, PTE1, MAG3110_I2C_ADDRESS);

// altimeter-Pressure-Temperature (apt)
#define MPL3115A2_I2C_ADDRESS (0x60<<1)
MPL3115A2 apt( PTE0, PTE1, MPL3115A2_I2C_ADDRESS);


int secondFlag;
int HsecondFlag;
unsigned int seconds;
unsigned int compass_type;
unsigned short adc_sample3;
float fcountperg = 1.0F / FCOUNTSPERG;
float fcountperut = 1.0F / FCOUNTSPERUT;

void accel_read(void)
{
    signed short resultx, resulty, resultz;
    if(acc.isDataAvailable())
    {
        resultx = acc.readReg(0x01)<<8;
        resultx |= acc.readReg(0x02);
        resultx = resultx >> 2;
        resulty = acc.readReg(0x03)<<8;
        resulty |= acc.readReg(0x04);
        resulty = resulty >> 2;
        resultz = acc.readReg(0x05)<<8;
        resultz |= acc.readReg(0x06);
        resultz = resultz >> 2;
        if(compass_type == NED_COMPASS)
        {
            axis6.acc_x = resultx;
            axis6.acc_y = -1 * resulty; // multiple by -1 to compensate for PCB layout
            axis6.acc_z = resultz;
        }
        if(compass_type == ANDROID_COMPASS)
        {
            axis6.acc_x = resulty; // 
            axis6.acc_y = -1 * resultx;
            axis6.acc_z = resultz;
        }
        if(compass_type == WINDOWS_COMPASS)
        {
            axis6.acc_x = -1 * resulty; // 
            axis6.acc_y = resultx;
            axis6.acc_z = resultz;
        }
        axis6.fax = axis6.acc_x;
        axis6.fay = axis6.acc_y;
        axis6.faz = axis6.acc_z;
        axis6.fGax = axis6.fax * fcountperg;
        axis6.fGay = axis6.fay * fcountperg;
        axis6.fGaz = axis6.faz * fcountperg;                    
    }
}

void readTempAlt(void) // We don't use the fractional data
{
    unsigned char raw_data[2];
    if(apt.getAltimeterRaw(&raw_data[0]))
        axis6.alt = ((raw_data[0] << 8) | raw_data[1]);
    if(apt.getTemperatureRaw(&raw_data[0]))
        axis6.temp = raw_data[0];
}

void readCompass( void )
{
    if(mag.isDataAvailable())
    {
        uint8_t  mx_msb, my_msb, mz_msb;
        uint8_t  mx_lsb, my_lsb, mz_lsb;

        mx_msb = mag.readReg(0x01);
        mx_lsb = mag.readReg(0x02);
        my_msb = mag.readReg(0x03);
        my_lsb = mag.readReg(0x04);
        mz_msb = mag.readReg(0x05);
        mz_lsb = mag.readReg(0x06);

        if(compass_type == NED_COMPASS)
        {
            axis6.mag_y = (((mx_msb << 8) | mx_lsb));      // x & y swapped to compensate for PCB layout
            axis6.mag_x = (((my_msb << 8) | my_lsb));
            axis6.mag_z = (((mz_msb << 8) | mz_lsb));
        }
        if(compass_type == ANDROID_COMPASS)
        {
            axis6.mag_x = (((mx_msb << 8) | mx_lsb));
            axis6.mag_y = (((my_msb << 8) | my_lsb));
            axis6.mag_z = -1 * (((mz_msb << 8) | mz_lsb)); // negate to reverse axis of Z to conform to Android coordinate system
        }
        if(compass_type == WINDOWS_COMPASS)
        {
            axis6.mag_x = (((mx_msb << 8) | mx_lsb));
            axis6.mag_y = (((my_msb << 8) | my_lsb));
            axis6.mag_z = -1 * (((mz_msb << 8) | mz_lsb));
        }
        axis6.fmx = axis6.mag_x;
        axis6.fmy = axis6.mag_y;
        axis6.fmz = axis6.mag_z;
        axis6.fUTmx = axis6.fmx * fcountperut;
        axis6.fUTmy = axis6.fmy * fcountperut;
        axis6.fUTmz = axis6.fmz * fcountperut;
    }
}   

void set_dir_LED(void)
{
    GREEN_OFF;
    RED_OFF;
    BLUE_OFF;
    
    if((axis6.compass >= 353) || (axis6.compass <= 7))
    {
        GREEN_ON;
    }
    else
    {
        GREEN_OFF;
    }
    if(((axis6.compass >= 348) && (axis6.compass <= 357)) || ((axis6.compass >= 3) && (axis6.compass <= 12)))
    {
        BLUE_ON;
    }
    else
    {
        BLUE_OFF;
    }
    if((axis6.compass >= 348) || (axis6.compass <= 12)) return;
    if(((axis6.compass >= 268) && (axis6.compass <= 272)) || ((axis6.compass >= 88) && (axis6.compass <= 92)))
    {
        RED_ON;
        return;
    }
    if((axis6.compass >= 178) && (axis6.compass <= 182))
    {
        BLUE_ON;
        RED_ON;
        return;
    }
}

void SysTick_Handler(void)
{
    static unsigned int ttt = 1;
    int ts;
    ts = ttt & 0x1;
    if(ts == 0)
    {
        accel_read();
        readCompass();
    }
    if(ts == 1)
    {
        run_eCompass();
        newData = 1; // a general purpose flag for things that need to synch to the ISR
        axis6.timestamp++;
        if(!server_running) set_dir_LED(); // Set the LEDs based on direction when nothing else is usng them
    }
    if(ttt == 50)
    {
        LED_D1_ON;
        if(seconds && (seconds < 15)) calibrate_eCompass();
        readTempAlt();
        axis6.light = ambi.readRaw(); // Light Sensor    
        HsecondFlag = 1; // A general purpose flag for things that need to happen every 500ms   
    }
    if(ttt >= 100)
    {
        LED_D1_OFF;
        ttt = 1;  
        calibrate_eCompass();
        Batt.sense_en(1);
        adc_sample3 = Batt.level(); 
        Batt.sense_en(0);
        secondFlag = 1; // A general purpose flag for things that need to happen once a second
        HsecondFlag = 1;
        seconds++;
        if(!(seconds & 0x1F)) do_mDNS = 1;          
    } else ttt++;
}

int main()
{
    int loop;
    int temp;
    unsigned int oldseconds;

    // set current to 500mA since we're turning on the Wi-Fi
    Batt.init(CHRG_500MA);

    // Unlock I2C bus if blocked by a device
    I2C_busreset();

    //Set baudrate to 115200 instead of the default 9600
    pc.baud (115200);

    initLEDs();
    Init_HostDriver();

    printf("\n\n\nWi-Go Master V3.3\n");
    printf("Firmware build version:  %s,  %s\n", __DATE__, __TIME__);
    // Initalize global variables
    axis6.packet_id = 1;
    axis6.timestamp = 0;
    axis6.acc_x = 0;
    axis6.acc_y = 0;
    axis6.acc_z = 0;
    axis6.mag_x = 0;
    axis6.mag_y = 0;
    axis6.mag_z = 0;
    axis6.roll = 0;
    axis6.pitch = 0;
    axis6.yaw = 0;
    axis6.compass = 0;      
    axis6.alt = 0;
    axis6.temp = 0;
    axis6.light = 0;
    compass_type = ANDROID_COMPASS;
    seconds = 0;
    runSmartConfig = 0;
    ulSmartConfigFinished = 0;
    server_running = 1;
    newData = 0;    
    secondFlag = 0;
    HsecondFlag = 0;
    socket_active_status = 0xFFFF;
    socket_active_status = SOCKET_STATUS_INIT_VAL;
    ForceFixedSSID = 0;
    GREEN_ON;

    // Read the Magnetometer a couple of times to initalize
    for(loop=0 ; loop < 5 ; loop++)
    {
        temp = mag.readReg(0x01);
        temp = mag.readReg(0x02);
        temp = mag.readReg(0x03);
        temp = mag.readReg(0x04);
        temp = mag.readReg(0x05);
        temp = mag.readReg(0x06);
        wait_ms(50);
    }

    init_eCompass();

    // Start 5ms Ticker
    systick.attach(&SysTick_Handler, 0.01);

    runSmartConfig = 0;
    ulSmartConfigFinished = 0;
    server_running = 1;
    newData = 0;    
    socket_active_status = SOCKET_STATUS_INIT_VAL;
    
    GREEN_ON;

    // Trigger a WLAN device
    wlan_start(0);
    nvmem_read( NVMEM_USER_FILE_1_FILEID, sizeof(userFS), 0, (unsigned char *) &userFS);
    nvmem_get_mac_address(myMAC);
    print_mac();
    wlan_stop();
    printf("FTC        %i\n",userFS.FTC);
    printf("PP_version %i.%i\n",userFS.PP_version[0], userFS.PP_version[1]);
    printf("SERV_PACK  %i.%i\n",userFS.SERV_PACK[0], userFS.SERV_PACK[1]);
    printf("DRV_VER    %i.%i.%i\n",userFS.DRV_VER[0], userFS.DRV_VER[1], userFS.DRV_VER[2]);
    printf("FW_VER     %i.%i.%i\n",userFS.FW_VER[0], userFS.FW_VER[1], userFS.FW_VER[2]);

    if(!userFS.FTC && !ForceFixedSSID)
    {
        do_FTC(); // Call First Time Configuration if SmartConfig has not been run, and fixed SSID is not enabled
        while(1)
        {
            printf("Reset system\n");
            GREEN_ON;
            secondFlag = 0;
            while(!secondFlag);
            secondFlag = 0;
            GREEN_OFF;
            while(!secondFlag);
        }
    }
    server_running = 1;

    // Wait for slider touch
    printf("\nUse the slider to start an application.\n");
    printf("Releasing the slider for more than 3 seconds\nwill start the chosen application.\n");
    printf("Touching the slider within the 3 seconds\ntimeframe allows you to re-select an application.\n");
    printf("\nThe RGB LED indicates the selection:\n");
    printf("PURPLE - Force SmartConfig.\n");
    printf("BLUE   - Webserver displaying live sensor data.\n");
    printf("RED    - Exosite data client.\n");
    printf("GREEN  - Android sensor fusion app.\n");
    while( tsi.readPercentage() == 0 )
    {
        RED_ON;
        wait(0.2);
        RED_OFF;
        wait(0.2);
    }
    RED_OFF

    oldseconds = seconds;
    loop = 100;
    temp = 0;
    // Read slider as long as it is touched.
    // If released for more than 3 seconds, exit
    while((loop != 0) || ((seconds - oldseconds) < 3))
    {
        loop = tsi.readPercentage() * 100;
        if(loop != 0)
        {
            oldseconds = seconds;
            temp = loop;
        }
        if(temp > 75)
        {
            BLUE_ON;
            RED_ON;
            GREEN_OFF;
        }
        else if(temp > 50)
        {
            BLUE_ON;
            GREEN_OFF;
            RED_OFF;
        }
        else if(temp > 25)
        {
            BLUE_OFF;   
            GREEN_OFF;
            RED_ON;
        }
        else
        {
            BLUE_OFF;
            GREEN_ON;
            RED_OFF;
        }
    }
    BLUE_OFF;
    GREEN_OFF;
    RED_OFF;

    server_running = 0;
    // Execute the user selected application
    if(temp > 75)
    { // Force SmartCOnfig
        server_running = 1;
        runSmartConfig = 1;
        initTCPIP();
        server_running = 1;
        RED_OFF;
        GREEN_OFF;
        BLUE_OFF;
        while(1)
        {
            printf("Reset system\n");
            GREEN_ON;
            secondFlag = 0;
            while(!secondFlag);
            secondFlag = 0;
            GREEN_OFF;
            while(!secondFlag);
        }
    } else SmartConfigProfilestored = SMART_CONFIG_SET; 

    RED_OFF;
    GREEN_OFF;
    BLUE_OFF; 
        
    // Start the selected application
    if(temp > 50)
    {
        compass_type = NED_COMPASS;
        init_eCompass();
        seconds = 0;
        demo_wifi_main();          // Run Webserver
    }
    if(temp > 25)
    {
        compass_type = NED_COMPASS;
        init_eCompass();
        seconds = 0;
        run_exosite();             // Send data to Exosite
    }
    init_eCompass();
    seconds = 0;
    runTCPIPserver();              // Run TCP/IP Connection to host
}



