#include "TEMT6200.h"
#include "ComparatorIn.h"
#include "mbed.h"

void ambi_rise(void);       // ISR callback pointer
void ambi_fall(void);       // ISR callback pointer

// RGB LED
DigitalOut cmpled (LED_GREEN);
DigitalOut blinky (LED_BLUE);

// Ambient light sensor to comparator plus input = PTC8, min input = 12-bit DAC0
ComparatorIn compi(PTC8, PTE30);

// Ambient light sensor : PTD5 = enable, PTB0 = analog input
TEMT6200 ambi(PTD5, PTB0);

int main()
{
    // Ambient light detector
    ambi.pwr(AMB_ON);
    printf("\n- Ambient light sensor calibration.\n");
    printf("  Make sure the sensor is obscured.\n");
    printf("  Press any key to calibrate.\n");
    getchar();
    ambi.calibrate();                                 // Calibrate 
    printf("- Calibration finished.\n");

    // Comparator settings
    compi.rising(&ambi_rise);                         // Set comparator rising int callback to ambi_rise
    compi.falling(&ambi_fall);                        // Set comparator falling int callback to ambi_fall
    compi.treshold(ambi.lux_pct(300.0));              // Set ISR treshold to 300lux

    cmpled = 1;
    
    while (1)
    {
        printf("%7.2f lux (%04X)\n",ambi.read(), ambi.readRaw());
        wait(0.5);
        blinky = !blinky;
    }
}

// Comparator callback
void ambi_rise(void)
{
    cmpled = 0;                       // Green led on.
}

void ambi_fall(void)
{
    cmpled = 1;                       // Green led off.
}
