/**************************************************************************************************
 *****                                                                                        *****
 *****  Name: TEMT6200.h                                                                      *****
 *****  Date: 15/06/2013                                                                      *****
 *****  Auth: Frank Vannieuwkerke                                                             *****
 *****  Func: library for TEMT6200 ambient light sensor                                       *****
 *****                                                                                        *****
 **************************************************************************************************/

#include "mbed.h"

#ifndef TEMT6200_H
#define TEMT6200_H
 
#define AMB_ON             (bool) 1
#define AMB_OFF            (bool) 0
#define TEMT_AREF          (float)3.3           // Analog reference voltage
#define TEMT_MAXLX         1290                 // Calculated max. lux
#define TEMT_AMP           11                   // Op-amp amplification
#define TEMT_IAVG          (float)0.02325       // Theoretical average Ipce @ 100lux
#define TEMT_DARKC         (float)0.000050      // Max. dark current
 
/** Class to use TEMT6200 ambient light sensor.
*
* 'en' pin can be any digital pin.
* 'level' pin MUST be an analog input
*/ 

class TEMT6200 {
public:
    /** Create a TEMT6200 object connected to 2 pins.
    *
    * @param en = Power on/off output
    * @param level = TEMT6200 analog level input
    * @return none
    */
    TEMT6200(PinName en, PinName level);

    /** Read TEMT6200 level (raw value).
    * @param none
    * @return unsigned short in the range [0x0, 0xFFFF].
    */
    unsigned short readRaw(void);

    /** Read TEMT6200 level (lux).
    * @param none
    * @return lux value (float)
    */
    float read(void);

    /** Power control.
    * @param AMB_ON  = enable light sensor
    * @param AMB_OFF = disable light sensor
    * @return none
    */
    void pwr(bool pwr);

    /** Calibrate the ambient light sensor.
    * @param none
    * @return none
    * @return . IMPORTANT : Totally obscure the sensor before calibration.
    * @return . This function will modify the Ipce100 variable.
    * @return . Running the calibration with an uncovered sensor will return the theoretical mean value.
    */
    void calibrate(void);

    /** Convert lux value to percentile.
    * @param input lux_val : lux value to be converted - range: 0..TEMT6200_MAXLX lux (float)
    * @return Value for setting ComparatorIn treshold (float)
    * @return . Conversion accuracy depends on the DAC input used with the comparator input:
    * @return . 6-bit for the internal DAC0, 12-bit for the external DAC.
    * @return . When 6-bit is used, the input lux value is rounded to the nearest multiple of TEMT6200_MAXLX / 64.
    */
    float lux_pct(float lux_val);

private:
    DigitalOut _en;
    AnalogIn _level;
    float Ipce100;
};

#endif
