/**************************************************************************************************
 *****                                                                                        *****
 *****  Name: TEMT6200.cpp                                                                    *****
 *****  Date: 15/06/2013                                                                      *****
 *****  Auth: Frank Vannieuwkerke                                                             *****
 *****  Func: library for TEMT6200 ambient light sensor                                       *****
 *****                                                                                        *****
 **************************************************************************************************/

#include "TEMT6200.h"

TEMT6200::TEMT6200(PinName en, PinName level) : _en(en), _level(level)
{
    _en = AMB_ON;                               // Enable ambient light sensor
    Ipce100 = TEMT_IAVG;
}
 
unsigned short TEMT6200::readRaw(void)
{
    return(_level.read_u16());
}

float TEMT6200::read(void)
{
    return(100 * (_level.read() * TEMT_AREF) / (TEMT_AMP * Ipce100));
}

void TEMT6200::pwr(bool pwr)
{
    _en = pwr;
}

void TEMT6200::calibrate(void)
{
    int sa_cnt, ds_cnt = 0;
    float tmp_d, dark_current = 0.0;
    Ipce100 = TEMT_IAVG;                            // Set Ipce back to its theoretical mean value
    for(sa_cnt = 0 ; sa_cnt < 10 ; sa_cnt++)
    {
        tmp_d = (_level.read() * TEMT_AREF) / TEMT_AMP;
        if(tmp_d < TEMT_DARKC)                      // We only use valid dark_current values
            dark_current += tmp_d;
        else
            ds_cnt++;
    }
    /*
     Only update Ipce when error count < sample count
     This is also a security measure : calibrating while the sensor is not covered 
                                       will set Ipce to the theoretical mean value.
    */
    if(ds_cnt < sa_cnt)
    {
        dark_current = dark_current  / (sa_cnt - ds_cnt);
        Ipce100 -= dark_current;
    }
}

float TEMT6200::lux_pct(float lux_val)
{
    float pct;
    pct = lux_val * TEMT_AMP * Ipce100 / (100 * TEMT_AREF);
    if(pct < 0.0)
    {
        return(0.0);
    }
    else if(pct > 1.0)
    {
        return(1.0);
    }
    else
    {
        return(pct);
    }
}



