/*
Authors : Erik Olieman/Frank Vannieuwkerke
------------------------------------------

    11/12/2012  Initial code (ported from Peter Drescher's code - http://mbed.org/cookbook/SPI-driven-QVGA-TFT
                Replaced DMA code with SPI code - modified several functions to fit ILI9320.

    12/12/2012  (SPI_TFT) Replaced circle and fillcircle with draw_ellipse and fill_ellipse
                          Modified rect and fillrect: use width and height parameters instead of x1,y1

    31/12/2012  lpc1768 SPI port: problem when using SD and TFT simultaneously - solution provided by Erik Olieman
                see note http://mbed.org/comments/cr/83/2654/#c4768

                Code readability and speed
                  1. created separate structure for mini-DK (base for library)
                  2. Removed wr_dat_only routine (uses 8 bit transfer = slow) in SPI_TFT
                     Replaced each wr_dat_only with
                       _spi.format(16,3);
                       .....
                       _spi.write(...);
                       .....
                       _spi.format(8,3);
                  3. Creation of Mini-DK.h with all declarations specific to the mini-DK board.

                Removed reset pin from SPI_TFT (not needed - pin is connected to main reset).

                Separated SPI_TFT from TouchADS7843
      
                In main.cpp
                ----------- 
                TouchScreenADS7843 initialisation: pointer to SPI_TFT needed for calibration, drawcross and drawpoint routines.
      
                Moved following global touch var declarations from main.cpp back to touch.cpp/.h
                  Matrix      matrix;
                  Coordinate  display;
                  Coordinate  screen;
                  NOTE : i did not create a class with var readback, just used plain C notation.
                         These vars can be accessed from other code through <classname>.<varname>
                         example : TP.display.x
                         Only drawback : Each element of these vars needs to be initialised separately.
                                         (initialisation of these vars is not possible with array notation).

                In Touch.cpp/.h
                ---------------
                TouchScreenADS7843 constructor: added pointer to SPI_TFT - needed for calibration, drawcross and drawpoint routines.
                                                If LCD calls are not needed, initialise TouchScreenADS7843 with NULL pointer for LCD.

                Removed TP_Init - moved TP_init code to constructor.

                Variables in call to TouchPanel_Calibrate, Read_Ads7846, getDisplayPoint are no longer needed.
                Modified these routines accordingly in touch.cpp/.h (pointers no longer needed)

                Read_Ads7846: is also called in TouchPanel_Calibrate (Touch.cpp) with other var.
                              Modified Read_Ads7846 to allow call with/without (parameter).
                              When called without (parameter) - screen variable is used, otherwise (parameter) is used.
                              in Touch.h - unsigned char Read_Ads7846(Coordinate * screenPtr); replaced with
                                           unsigned char Read_Ads7846(Coordinate * screenPtr = NULL);
                              in Touch.cpp - if (screenPtr == NULL) screenPtr = &screen; added.

      
      
      
                In SPI_TFT
                ----------
                Changed the SPI object to a BurstSPI object
                All cases where large numbers of bytes are written (filled rect, cls, etc) have been replaced by fastWrite functions for higher speed
                mbed library updated to this century
                Colorwheel stepsize reduced to 1 in main.cpp
      
                Known issues: claim function for stdout does not work
                              Removed stream name from TextDisplay (not used in current mbed version)


    03/01/2013  General cleaning:
                    SPI_TFT::window function changed to use ints instead of unsigned ints, and made virtual to remove warnings.
                    In SPI_TFT.cpp GraphicsDiplay initialization moved to front to remove warnings
                    In Touch.cpp TFT pointer initialization moved to front to remove warnings
                    In Mini_DK.h    Added SD card pins
                                    Added two macros to enable/disable the LCD MISO pin, allowing use of both SD card and LCD
                                    Usage (in your main function): 
                                        ENABLE_LCD_MISO when you want to read from LCD
                                        DISABLE_LCD_MISO when you want to read from SD
                Faster SPI write: BurstSPI libary added.
                                  _spi.write replaced with _spi.fastWrite
                                  (http://mbed.org/users/Sissors/code/BurstSPI/docs/600eecd89a78/BurstSPI_8cpp_source.html)
                Code cleanup & comments added.
                Separate Mini_DK library created.
                
    04/01/2013  Added ability to use bitmaps from any filesystem.
                Added conversion to be able to use 24 bit bitmaps.
                NOTE : Don't forget to load the official mbed SDFileSystem library!! 
                
    06/01/2013  Bug fix in Bitmap function: orientation.
                Added IAP (In-Application programming): internal Flash memory access library.
                Added option to use a background image: #define USE_FLASH_BUFFER introduced in SPI_TFT.h
                                                        When omitted, the bitmap is NOT copied to flash memory.
                Bitmap function: comments about return codes updated.
                Background image remains static when orientation is changed.
                Constructor modified in SPI_TFT: backgroundOrientation = 0;
                                                 changed to
                                                 #ifdef USE_FLASH_BUFFER
                                                 backgroundOrientation = 0;
                                                 #endif
                                                 
    08/01/2013  Stream & claim issues resolved: mbed library has been updated by the mbed team to allow
                                                stream name => claim function can be used again.
                                                Changed 'TextDisplay::TextDisplay(const char *name) : Stream()' back to 
                                                TextDisplay::TextDisplay(const char *name) : Stream(name) in TextDisplay.cpp
                #define USE_FLASH_BUFFER (SPI_TFT.h) replaced with #define NO_FLASH_BUFFER (Mini_DK.h). When copy to flash
                is not needed, enable this option.
                
    09/01/2013  Code cleanup: modifs.h streamlined.
                              SPI_TFT.cpp and SPI_TFT.h comments.
                              Touch.cpp commnets.

*/