/**************************************************************************************************
 *****                                                                                        *****
 *****  Name: Mini_DK.h                                                                       *****
 *****  Ver.: 1.0                                                                             *****
 *****  Date: 04/01/2013                                                                      *****
 *****  Auth: Erik Olieman                                                                    *****
 *****  Func: Includes, pin and macro Declarations for the Mini DK board                      *****
 *****                                                                                        *****
 **************************************************************************************************/
//Uncomment the following line if you need more flash memory.
//#define NO_FLASH_BUFFER

#include "SPI_TFT_ILI9320.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "Touch.h"

#define DK_KEY1     P2_11
#define DK_KEY2     P2_12

#define DK_LED1     P3_25
#define DK_LED2     P3_26

#define LCD_SCK     P0_15
#define LCD_CS      P0_16
#define LCD_SDO     P0_17
#define LCD_SDI     P0_18
#define LCD_BL      P1_26

#define TP_IRQ      P2_13
#define TP_CS       P0_6
#define TP_SCK      P0_7
#define TP_SDO      P0_8
#define TP_SDI      P0_9

#define SD_SDO      P1_23
#define SD_SDI      P1_24
#define SD_SCK      P1_20
#define SD_CS       P1_21
#define SD_CD       P1_25

#define DISABLE_LCD_MISO    (LPC_PINCON->PINSEL1) &= ~(0x02<<2);
#define ENABLE_LCD_MISO     (LPC_PINCON->PINSEL1) |=  (0x02<<2);