/******************************************************************
 *****                                                        *****
 *****  Name: easyweb.cpp                                     *****
 *****  Ver.: 1.0                                             *****
 *****  Date: 17/12/2012                                      *****
 *****  Auth: Frank Vannieuwkerke                             *****
 *****  Func: implements a dynamic HTTP-server by using       *****
 *****        the easyWEB-API                                 *****
 *****        Rewrite from Andreas Dannenberg                 *****
 *****                     HTWK Leipzig                       *****
 *****                     university of applied sciences     *****
 *****                     Germany                            *****
 *****                     adannenb@et.htwk-leipzig.de        *****
 *****                                                        *****
 ******************************************************************/

#include "stdio.h"
#include "mbed.h"
#include "Mini_DK.h"

//#include "stdlib.h"
//#include "string.h"

// SPI TFT
// TFT -> mosi, miso, sclk, cs
SPI_TFT TFT(LCD_SDI, LCD_SDO, LCD_SCK, LCD_CS,"TFT");


#include "easyweb.h"
#include "ethmac.h"
#include "tcpip.h"                               // easyWEB TCP/IP stack
#include "website.h"                             // website for our HTTP server (HTML)

unsigned int aaPagecounter=0;
unsigned int adcValue = 0;

int main (void)
{

    TFT.claim(stdout);        // send stdout to the TFT display
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen
    TFT.set_font((unsigned char*) Arial12x12);  // select the font

    // Display IP/MAC settings stored in tcpip.h and ethmac.h
    // MAC address : 6-5-4-3-2-1        Stored in ethmac.h (MYMAC_1 to MYMAC_6)
    // IP address  : 192.168.0.200      Stored in tcpip.h  (MYIP_1 to MYIP_4)
    // gateway     : 192.168.0.1        Stored in tcpip.h  (GWIP_1 to GWIP_1)
    // mask        : 255.255.255.0      Stored in tcpip.h  (SUBMASK_1 to SUBMASK_4)
    TFT.locate(0,0);
    printf("IP address\n");
    printf("%d.%d.%d.%d\n\n",MYIP_1,MYIP_2,MYIP_3,MYIP_4);
    printf("MAC address\n");
    printf("%02X:%02X:%02X:%02X:%02X:%02X\n\n",MYMAC_6, MYMAC_5, MYMAC_4, MYMAC_3, MYMAC_2, MYMAC_1);
    printf("Initialising..please wait..\n\n");
    TCPLowLevelInit();

/*
  *(unsigned char *)RemoteIP = 24;               // uncomment those lines to get the
  *((unsigned char *)RemoteIP + 1) = 8;          // quote of the day from a real
  *((unsigned char *)RemoteIP + 2) = 69;         // internet server! (gateway must be
  *((unsigned char *)RemoteIP + 3) = 7;          // set to your LAN-router)

  TCPLocalPort = 2025;
  TCPRemotePort = TCP_PORT_QOTD;

  TCPActiveOpen();

  while (SocketStatus & SOCK_ACTIVE)             // read the quote from memory
  {                                              // by using the hardware-debugger
    DoNetworkStuff();
  }
*/

  HTTPStatus = 0;                                // clear HTTP-server's flag register

  TCPLocalPort = TCP_PORT_HTTP;                  // set port we want to listen to
 
  printf("Webserver running");
  
  while (1)                                      // repeat forever
  {
    if (!(SocketStatus & SOCK_ACTIVE)) TCPPassiveOpen();   // listen for incoming TCP-connection
    DoNetworkStuff();                                      // handle network and easyWEB-stack
                                                           // events
    HTTPServer();
  }
}

// This function implements a very simple dynamic HTTP-server.
// It waits until connected, then sends a HTTP-header and the
// HTML-code stored in memory. Before sending, it replaces
// some special strings with dynamic values.
// NOTE: For strings crossing page boundaries, replacing will
// not work. In this case, simply add some extra lines
// (e.g. CR and LFs) to the HTML-code.

void HTTPServer(void)
{
  if (SocketStatus & SOCK_CONNECTED)             // check if somebody has connected to our TCP
  {
    if (SocketStatus & SOCK_DATA_AVAILABLE)      // check if remote TCP sent data
      TCPReleaseRxBuffer();                      // and throw it away

    if (SocketStatus & SOCK_TX_BUF_RELEASED)     // check if buffer is free for TX
    {
      if (!(HTTPStatus & HTTP_SEND_PAGE))        // init byte-counter and pointer to website
      {                                          // if called the 1st time
        HTTPBytesToSend = sizeof(website) - 1;   // get HTML length, ignore trailing zero
        Pwebsite = (unsigned char *)website;     // pointer to HTML-code
      }

      if (HTTPBytesToSend > MAX_TCP_TX_DATA_SIZE)     // transmit a segment of MAX_SIZE
      {
        if (!(HTTPStatus & HTTP_SEND_PAGE))           // 1st time, include HTTP-header
        {
          memcpy(TCP_TX_BUF, GetResponse, sizeof(GetResponse) - 1);
          memcpy(TCP_TX_BUF + sizeof(GetResponse) - 1, Pwebsite, MAX_TCP_TX_DATA_SIZE - sizeof(GetResponse) + 1);
          HTTPBytesToSend -= MAX_TCP_TX_DATA_SIZE - sizeof(GetResponse) + 1;
          Pwebsite += MAX_TCP_TX_DATA_SIZE - sizeof(GetResponse) + 1;
        }
        else
        {
          memcpy(TCP_TX_BUF, Pwebsite, MAX_TCP_TX_DATA_SIZE);
          HTTPBytesToSend -= MAX_TCP_TX_DATA_SIZE;
          Pwebsite += MAX_TCP_TX_DATA_SIZE;
        }
          
        TCPTxDataCount = MAX_TCP_TX_DATA_SIZE;   // bytes to xfer
        InsertDynamicValues();                   // exchange some strings...
        TCPTransmitTxBuffer();                   // xfer buffer
      }
      else if (HTTPBytesToSend)                  // transmit leftover bytes
      {
        memcpy(TCP_TX_BUF, Pwebsite, HTTPBytesToSend);
        TCPTxDataCount = HTTPBytesToSend;        // bytes to xfer
        InsertDynamicValues();                   // exchange some strings...
        TCPTransmitTxBuffer();                   // send last segment
        TCPClose();                              // and close connection
        HTTPBytesToSend = 0;                     // all data sent
      }

      HTTPStatus |= HTTP_SEND_PAGE;              // ok, 1st loop executed
    }
  }
  else
    HTTPStatus &= ~HTTP_SEND_PAGE;               // reset help-flag if not connected
}

// Pseudo AD convertor, we simply increment  a counter
// when the function is called, wrapping at 1024. 
volatile unsigned int aaScrollbar = 400;

unsigned int GetAD7Val(void)
{
  aaScrollbar = (aaScrollbar +16) % 1024;
  adcValue = (aaScrollbar / 10) * 1000/1024;
  return aaScrollbar;
}

void InsertDynamicValues(void)
{
  unsigned char *Key;
           char NewKey[6];
  unsigned int i;
  
  if (TCPTxDataCount < 4) return;                     // there can't be any special string
  
  Key = TCP_TX_BUF;
  
  for (i = 0; i < (TCPTxDataCount - 3); i++)
  {
    if (*Key == 'A')
     if (*(Key + 1) == 'D')
       if (*(Key + 3) == '%')
         switch (*(Key + 2))
         {
           case '8' :                                 // "AD8%"?
           {
             sprintf(NewKey, "%04d", GetAD7Val());     // insert pseudo-ADconverter value
             memcpy(Key, NewKey, 4);                  
             break;
           }
           case '7' :                                 // "AD7%"?
           {
             sprintf(NewKey, "%3u", adcValue);     // copy saved value from previous read
             memcpy(Key, NewKey, 3);                 
             break;
           }
           case '1' :                                 // "AD1%"?
           {
              sprintf(NewKey, "%4u", ++aaPagecounter);    // increment and insert page counter
             memcpy(Key, NewKey, 4);  
//             *(Key + 3) = ' ';  
             break;
           }
         }
    Key++;
  }
}
