/**************************************************************************************************
 *****                                                                                        *****
 *****  Name: KL25Z_irq_prio.cpp                                                              *****
 *****  Date: 14/08/2013                                                                      *****
 *****  Auth: Frank Vannieuwkerke                                                             *****
 *****  Func: library for changing all IRQ priorities at once                                 *****
 *****                                                                                        *****
 **************************************************************************************************/

#include "KL25Z_irq_prio.h"

void NVIC_SetAllPriority(int prio)
{
//    NVIC_SetPriority(NonMaskableInt_IRQn,prio); //!! NOT POSSIBLE - FIXED TO 0
//    NVIC_SetPriority(HardFault_IRQn,prio);      //!! NOT POSSIBLE - FIXED TO 0
    NVIC_SetPriority(SVCall_IRQn,prio);
    NVIC_SetPriority(PendSV_IRQn,prio);
    NVIC_SetPriority(SysTick_IRQn,prio);
    NVIC_SetPriority(DMA0_IRQn,prio);
    NVIC_SetPriority(DMA1_IRQn,prio);
    NVIC_SetPriority(DMA2_IRQn,prio);
    NVIC_SetPriority(DMA3_IRQn,prio);
    NVIC_SetPriority(Reserved20_IRQn,prio);
    NVIC_SetPriority(FTFA_IRQn,prio);
    NVIC_SetPriority(LVD_LVW_IRQn,prio);
    NVIC_SetPriority(LLW_IRQn,prio);
    NVIC_SetPriority(I2C0_IRQn,prio);
    NVIC_SetPriority(I2C1_IRQn,prio);
    NVIC_SetPriority(SPI0_IRQn,prio);
    NVIC_SetPriority(SPI1_IRQn,prio);
    NVIC_SetPriority(UART0_IRQn,prio);
    NVIC_SetPriority(UART1_IRQn,prio);
    NVIC_SetPriority(UART2_IRQn,prio);
    NVIC_SetPriority(ADC0_IRQn,prio);
    NVIC_SetPriority(CMP0_IRQn,prio);
    NVIC_SetPriority(TPM0_IRQn,prio);
    NVIC_SetPriority(TPM1_IRQn,prio);
    NVIC_SetPriority(TPM2_IRQn,prio);
    NVIC_SetPriority(RTC_IRQn,prio);
    NVIC_SetPriority(RTC_Seconds_IRQn,prio);
    NVIC_SetPriority(PIT_IRQn,prio);
    NVIC_SetPriority(Reserved39_IRQn,prio);
    NVIC_SetPriority(USB0_IRQn,prio);
    NVIC_SetPriority(DAC0_IRQn,prio);
    NVIC_SetPriority(TSI0_IRQn,prio);
    NVIC_SetPriority(MCG_IRQn,prio);
    NVIC_SetPriority(LPTimer_IRQn,prio);
    NVIC_SetPriority(Reserved45_IRQn,prio);
    NVIC_SetPriority(PORTA_IRQn,prio);
    NVIC_SetPriority(PORTD_IRQn,prio);
}




