/*
KL25Z - ILI9320 SPI demo:
Display some text and graphics, followed by a simple paint demo.
*/

#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9320.h"
#include "Touch.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

extern unsigned char p1[];  // the mbed logo
#define RGB565CONVERT(red, green, blue) (uint16_t)( (( red   >> 3 ) << 11 ) | (( green >> 2 ) << 5  ) | ( blue  >> 3 ))

// TFT -> mosi, miso, sclk, cs
SPI_TFT TFT(PTD3, PTD2, PTD1, PTD0,"TFT");

// ADS7843 -> mosi, miso, sclk, cs, irq, SPI_TFT
TouchScreenADS7843 TP(PTD6 ,PTD7 ,PTD5 ,PTD4 ,PTA13, &TFT);

int main()
{
    Matrix matrix;
    Coordinate ScreenSample[3];

    unsigned short LCD_id;
    TFT.claim(stdout);        // send stdout to the TFT display
    // Disable stdout buffering, allows us to omit \n with printf.
    // More info at http://www.cplusplus.com/reference/cstdio/setvbuf/
    setvbuf ( stdout , NULL , _IONBF , NULL );

    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white

    // LCD demo
    // first show the 4 directions
    TFT.cls();
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.set_orientation(0);
    TFT.locate(0,0);
    printf("  Hello Mbed 0");
    TFT.set_orientation(1);
    TFT.locate(0,0);
    printf("  Hello Mbed 1");
    TFT.set_orientation(2);
    TFT.locate(0,0);
    printf("  Hello Mbed 2");
    TFT.set_orientation(3);
    TFT.locate(0,0);
    printf("  Hello Mbed 3");
    TFT.set_orientation(1);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(50,100);
    printf("TFT orientation");
    wait(2);

    // draw some graphics
    TFT.cls();
    TFT.set_orientation(1);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(120,115);
    printf("Graphic");
    TFT.line(0,0,100,200,Green);
    TFT.rect(100,50,50,50,Red);
    TFT.fillrect(180,25,40,45,Blue);
    TFT.draw_ellipse(80, 150, 33, 33, White);
    TFT.fill_ellipse(80, 50, 33, 33, White);
    wait(2);
    TFT.cls();
    TFT.draw_ellipse(160, 120, 100, 50, Yellow);
    TFT.draw_ellipse(160, 120, 100, 100, Blue);
    TFT.fill_ellipse(160, 120, 80, 40, Green);
    wait(2);

    // bigger text
    TFT.foreground(White);
    TFT.background(Blue);
    TFT.cls();
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(0,0);
    printf("Different Fonts :");

    TFT.set_font((unsigned char*) Neu42x35);
    TFT.locate(0,50);
    printf("Hello");
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(50,100);
    printf("Hello");
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(55,150);
    printf("Hello");

    TFT.set_orientation(2);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(10,10);
    printf("Hi mbed");
    wait(2);
    // mbed logo
    TFT.set_orientation(1);
    TFT.background(Black);
    TFT.cls();
    TFT.Bitmap(90,90,172,55,p1);

    // Read LCD ID
    TFT.set_orientation(0);
    LCD_id = TFT.Read_ID();
    TFT.locate(10,10);
    printf("LCD: ILI%04X", LCD_id);
    wait(2);

    // RGB color wheel demo (cycle through all colors)
    TFT.cls();
    TFT.foreground(Yellow);    // set chars to yellow
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(10,10);
    printf("RGB color wheel (2x)");

    uint8_t r = 255, g = 0,  b = 0, step = 5, i;
    for (i=0;i<2;i++)
    {
        for(;g<255;g+=step) {TFT.fillrect(70,110,100,100,RGB565CONVERT(r, g, b));}      // Cycle from FF0000 to FFFF00 : red to yellow
        for(;r>0;r-=step)   {TFT.fillrect(70,110,100,100,RGB565CONVERT(r, g, b));}      // Cycle from FFFF00 to 00FF00 : yellow to green
        for(;b<255;b+=step) {TFT.fillrect(70,110,100,100,RGB565CONVERT(r, g, b));}      // Cycle from 00FF00 to 00FFFF : green to cyan
        for(;g>0;g-=step)   {TFT.fillrect(70,110,100,100,RGB565CONVERT(r, g, b));}      // Cycle from 00FFFF to 0000FF : cyan to blue
        for(;r<255;r+=step) {TFT.fillrect(70,110,100,100,RGB565CONVERT(r, g, b));}      // Cycle from 0000FF to FF00FF : blue to purple
        for(;b>0;b-=step)   {TFT.fillrect(70,110,100,100,RGB565CONVERT(r, g, b));}      // Cycle from FF00FF to FF0000 : purple to red
    }
    wait(2);

    // Touchpanel demo
    TP.TouchPanel_Calibrate();
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.set_orientation(0);
    // Display calibration values
    TP.GetCalibration(&matrix, &ScreenSample[0]);
    TFT.cls();
    TFT.locate(0,20);
    // read calibration results
    printf("Read calibration results.\n");
    printf("matrix.An = %d\n", matrix.An);
    printf("matrix.Bn = %d\n", matrix.Bn);
    printf("matrix.Cn = %d\n", matrix.Cn);
    printf("matrix.Dn = %d\n", matrix.Dn);
    printf("matrix.En = %d\n", matrix.En);
    printf("matrix.Fn = %d\n", matrix.Fn);
    printf("matrix.Di = %d\n", matrix.Divider);
    for (i=0;i<3;i++)
        printf("sample x[%d] = %d\nsample y[%d] = %d\n", i, ScreenSample[i].x, i, ScreenSample[i].y);
    // Write calibration results
    printf("\nWrite calibration results...\n");
    TP.SetCalibration(&matrix, &ScreenSample[0]);
    printf("Done.\nTouch panel to read again.\n");
    while(TP._tp_irq);
    // read calibration results
    TFT.cls();
    TFT.locate(0,20);
    printf("Calibration results.\n\n");
    printf("matrix.An = %d\n", matrix.An);
    printf("matrix.Bn = %d\n", matrix.Bn);
    printf("matrix.Cn = %d\n", matrix.Cn);
    printf("matrix.Dn = %d\n", matrix.Dn);
    printf("matrix.En = %d\n", matrix.En);
    printf("matrix.Fn = %d\n", matrix.Fn);
    printf("matrix.Di = %d\n", matrix.Divider);
    for (i=0;i<3;i++)
        printf("sample x[%d] = %d\nsample y[%d] = %d\n", i, ScreenSample[i].x, i, ScreenSample[i].y);
    
    TFT.locate(0,0);
    printf(" X:");
    TFT.locate(70,0);
    printf(" Y:");
    while (1)
    {
        if (!TP._tp_irq)
        {
            if (TP.Read_Ads7843())
            {
                TP.getDisplayPoint() ;
                TP.TP_DrawPoint(TP.display.x,TP.display.y, Blue);
                TFT.locate(25,0);
                printf("%03d",TP.display.x);
                TFT.locate(95,0);
                printf("%03d",TP.display.y);
                // Touchscreen area is larger than LCD area.
                // We use the bottom area outside the LCD area to clear the screen (y value > 320).
                if (TP.display.y > 320)
                {
                    TFT.cls();
                    TFT.locate(0,0);
                    printf(" X:");
                    TFT.locate(70,0);
                    printf(" Y:");
                }
            }
        }
    }
}

