#ifndef DemoClass_H
#define DemoClass_H

#include "mbed.h"

class DemoClass {
public:
    /**
     *  \brief Create an object connected to I2C bus, irq input or digital output and user-ISR.
     *  \param sda       SDA pin.
     *  \param scl       SCL pin.
     *  \param irqsync   Interrupt input when called with user-ISR pointer.
     *                   Digital output when called without user-ISR pointer.
     *  \param fptr      Pointer to user-ISR.
     *  \return none
     */

    DemoClass(PinName sda, PinName scl, PinName irqsync = NC, void (*fptr)(void) = NULL);

    /**
     *  \brief Example status function.
     *  \param none.
     *  \return Always 1.
     */
    bool Status(void);

private:
    I2C _i2c;
    FunctionPointer _fptr;
    void _sensorISR(void);
};

#endif
