#include "DemoClass.h"

InterruptIn *_irqpin;
DigitalOut *_syncpin;

// Depending on how the ctor is called, irqsync is either set to none, InterruptIn or DigitalOut
DemoClass::DemoClass(PinName sda, PinName scl, PinName irqsync, void (*fptr)(void)) : _i2c(sda, scl)
{
    // When both irqsync and fptr are nonzero, we use InterruptIn: irqsync pin is interrupt input and Attach ISR.
    if((irqsync != NC) && (fptr != NULL))
    {
        _irqpin = new InterruptIn(irqsync);             // Create InterruptIn pin
        _irqpin->fall(this, &DemoClass::_sensorISR);    // Attach falling interrupt to local ISR
        _fptr.attach(fptr);                             // Attach function pointer to user function
    }
    
    // When fptr is not defined, we use DigitalOut: irqsync pin is digital output.
    if((irqsync != NC) && (fptr == NULL))
    {
        _syncpin = new DigitalOut(irqsync);             // Create DigitalOut pin
        _syncpin->write(0);                             // Set pin to 0
    }
}

bool DemoClass::Status(void)
{
    return (1);
}

void DemoClass::_sensorISR(void)
{
   uint8_t statret = Status();        // Read a status register (eg : to clear an interrupt flag).
   _fptr.call();                      // Call the user-ISR
}
