#include "ComparatorIn.h"
#include "mbed.h"

DigitalOut blinker (LED_BLUE);
DigitalOut cmpled (LED_GREEN);
DigitalOut cmp_en (PTD5);
AnalogIn cmp_lvl (PTB0);
ComparatorIn compi(PTC8, PTE30); // in+ = PTC8, in- = 12-bit DAC 

// Comparator callback functions
void cmp_rise_ISR(void)
{
    cmpled = 0;
}

void cmp_fall_ISR(void)
{
    cmpled = 1;
}



int main()
{
    cmp_en = 1;
    cmpled = 1;

    compi.rising(&cmp_rise_ISR);                // Set pointer to rising interrupt function
    compi.falling(&cmp_fall_ISR);               // Set pointer to falling interrupt function
    compi.treshold(0.3);                        // Set comparator threshold to 1V = 0.3 * 3.3V

    while(1)
    {
        printf("Light sensor : %7.5f Volt\n",cmp_lvl*3.3);
        blinker = 1;
        wait(1);
        blinker = 0;
        wait(0.2);
        if (compi.status() == 0x01)
        {
            printf("*** Treshold reached : %7.5f\n",cmp_lvl*3.3);
        }
    }
}



