/****************************************************************************
*
*  doTCPIP.h - CC3000 TCP/IP
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/

#ifndef DOTCPIP_H
#define DOTCPIP_H

#include "cc3000.h"

/** TCP/IP Functions
*
*/
#ifdef    __cplusplus
extern "C" {
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#define SMART_CONFIG_SET 0x55
// SMTP Specific
#define HTTP_PORT     80
#define TCPIP_PORT    15000

#define USE_DHCP      1
#define USE_STATIC_IP 2

#define NONE 0
#define WEP  1
#define WPA  2
#define WPA2 3

// Modify the following settings as necessary for your Wi-Fi Network setup:
#define IP_ALLOC_METHOD USE_DHCP        // for DHCP assigned IP address   
//#define IP_ALLOC_METHOD USE_STATIC_IP // for static IP address

// Default SSID Settings
//#define AP_KEY         "thisthis" 
//#define AP_SECURITY    WPA2          // WPA2 must be enabled for use with iPhone or Android phone hotspot!
#define SSID           "iot"
#define AP_SECURITY    NONE          // no security but will connect quicker!  
#define STATIC_IP_OCT1 192
#define STATIC_IP_OCT2 168
#define STATIC_IP_OCT3 0
#define STATIC_IP_OCT4 10

#define STATIC_GW_OCT4 1             // Static Gateway address  = STATIC_IP_OCT1.STATIC_IP_OCT2.STATIC_IP_OCT3.STATIC_GW_OCT4

#define REQ_BUFFER_SIZE 400

// DynDNS server. From which to take public IP address.
// dyndns: 91.198.22.70
#define SRV_IP_OCT1 91
#define SRV_IP_OCT2 198
#define SRV_IP_OCT3 22
#define SRV_IP_OCT4 70
#define SRV_PORT    80

// Italian daytime server responding:
// 29 AUG 2013 05:24:02 CEST
// tempo.ien.it [193.204.114.105]
#define TMSRV_IP_OCT1 193
#define TMSRV_IP_OCT2 204
#define TMSRV_IP_OCT3 114
#define TMSRV_IP_OCT4 105
#define TMSRV_PORT    13

typedef struct {
    unsigned char FTC;           // First time config performed
    unsigned char PP_version[2]; // Patch Programmer version
    unsigned char SERV_PACK[2];  // Service Pack Version
    unsigned char DRV_VER[3];    // Driver Version
    unsigned char FW_VER[3];     // Firmware Version
    unsigned char validCIK;      // CIK[] is valid (Client Interface Key)
    unsigned char CIK[40];
} userFS_t;

extern userFS_t userFS;

extern volatile unsigned long ulSmartConfigFinished,ulCC3000DHCP, OkToDoShutDown, ulCC3000DHCP_configured;
extern int server_running;
extern volatile unsigned char newData;
extern unsigned char ForceFixedSSID;
extern char runSmartConfig;
extern char requestBuffer[];
extern unsigned char myMAC[8];
extern unsigned char SmartConfigProfilestored;
extern int do_mDNS;
extern int HsecondFlag;
extern unsigned int seconds;
extern volatile int ms5Flag;

extern void StartSmartConfig(void);


//int sendTCPIP(int port);
void sendPython(int port);
void initTCPIP(void);
void runTCPIPserver(void);
int getTCPIP( char a1, char a2, char a3, char a4, int port);
//void runTCPIPclient(int a1, int a2, int a3, int a4);
void runTCPIPclient(int a1, int a2, int a3, int a4, int port);

/** Checks if WiFi is still connected.
* @param  None
* @return TRUE if connected, FALSE if not
* @note   If not associated with an AP for 5 consecutive retries, it will reset the board.
*/
unsigned char checkWiFiConnected(void);

/** Print MAC address.
* @param  None
* @return none
*/
void print_mac(void);

/** First time configuration.
* @param  None
* @return none
*/
void do_FTC(void);

#ifdef    __cplusplus
}
#endif // __cplusplus

#endif // DOTCPIP_H

