/****************************************************************************
*
*  doTCPIP.cpp - CC3000 TCP/IP
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/

#include "doTCPIP.h"

volatile unsigned char newData;
int server_running;
unsigned char ForceFixedSSID;
char runSmartConfig;            // Flag indicating whether user requested to perform Smart Config
volatile unsigned long ulCC3000Connected;
unsigned char ConnectUsingSmartConfig;
unsigned char myMAC[8];
userFS_t userFS;
int do_mDNS = 0;

// Setup the functions to handle our CGI parameters
tNetappIpconfigRetArgs ipinfo2;
char requestBuffer[REQ_BUFFER_SIZE];
int LAN_Connected = 0;

unsigned char SmartConfigProfilestored = 0xff;

  
/** \brief Flag indicating whether to print CC3000 Connection info */
static unsigned char obtainIpInfoFlag = FALSE;
//Device name - used for Smart config in order to stop the Smart phone configuration process
char DevServname[] = "CC3000";
volatile unsigned long SendmDNSAdvertisment;

/*int sendTCPIP(int port)
{
    long temp, stat, skip, skipc;
    //socket descriptor 
    long sock;
    //new TCP socket descriptor
    long newsock;
    //destination address
    sockaddr destAddr;
    //local address
    sockaddr LocalAddr;

//    char buf2[40];
    socklen_t addrlen;
    memset(&LocalAddr, 0, 8);
    LocalAddr.sa_family = AF_INET;
    LocalAddr.sa_data[0] = (port >> 8) & 0xff;
    LocalAddr.sa_data[1] = port & 0xff;  
    memset (&LocalAddr.sa_data[2], 0, 4);
    sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    while(sock == -1) sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_TCP);
    temp = bind(sock,&LocalAddr,sizeof(sockaddr));
    temp = listen(sock, 1);
    addrlen = sizeof(destAddr);
    skip = 0;
    skipc = 0;
    while(1)
    {
        newsock = -2;
        printf("Server waiting for connection\n");
        LED_D2_ON;
        while((newsock == -1) || (newsock == -2))
        {
            newsock = accept(sock,&destAddr, &addrlen);
            if(do_mDNS)
            {
                printf("mDNS= 0x%08x\n", mdnsAdvertiser(1, DevServname, sizeof(DevServname)));
                do_mDNS = 0;
            }
        }
        printf("Connected\n");
 //       sss = seconds;
        //receive TCP data
        temp = 0;   
        if(newsock >= 0)
        {
            recv(newsock, requestBuffer,20,0);
            printf("Input = %s\n", requestBuffer);
            while(1)
            {
                while(!newData) __wfi();
                newData = 0;
                LED_D2_ON;  
                stat = -2;
                //if(tSLInformation.usNumberOfFreeBuffers <= 2)
                //{
                //    printf("LOW= %d\n", tSLInformation.usNumberOfFreeBuffers);
                //}
                //Disable sys tick interrupts for debugging
                //SysTick->CTRL &= ~SysTick_CTRL_TICKINT_Msk;       // *** Disable SysTick Timer Interrupt
//                stat = send(newsock,&axis6, sizeof(axis6), 0);
                // Disable sys tick interrupts for debugging
                //SysTick->CTRL |= SysTick_CTRL_TICKINT_Msk;        // *** Enable SysTick Timer Interrupt   
                LED_D2_OFF;
                if(stat != 96)
                {
                    if(stat == -2)
                    {
                        skip++;
                        skipc++;
                    }
                    //printf("status= %d\n", stat);
                    if(stat == -1) break;
                }
                else
                {
                    temp++;
                    skipc = 0;
                }
                if(skipc > 150)
                {
//                    printf("Zero Buffer Error Sent\n", temp, seconds - sss);
                    return(-1);
                }
            }   
        } else printf("bad socket= %d\n", newsock);
        closesocket(newsock);
//        printf("Done %d, time= %d, skipped= %d\n", temp, seconds - sss, skip);
        skip = 0;
    }
}*/

void sendPython(int port)
{
    char python_msg[] = "Hello Python\n";
    int stat;
    long sock;
    //new TCP socket descriptor
    long newsock;
    //destination address
    sockaddr destAddr;
    //local address
    sockaddr LocalAddr;
    socklen_t addrlen;
    memset(&LocalAddr, 0, 8);
    LocalAddr.sa_family = AF_INET;
    LocalAddr.sa_data[0] = (port >> 8) & 0xff;
    LocalAddr.sa_data[1] = port & 0xff;  
    memset (&LocalAddr.sa_data[2], 0, 4);
    sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    while(sock == -1) sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_TCP);
    bind(sock,&LocalAddr,sizeof(sockaddr));
    listen(sock, 1);
    addrlen = sizeof(destAddr);
    while(1)
    {
        newsock = -2;
        printf("\nServer waiting for connection to Python\n");
        LED_D2_ON;
        while((newsock == -1) || (newsock == -2))
        {
            newsock = accept(sock,&destAddr, &addrlen);
        }
        printf("Connected\n");
        //receive TCP data
        if(newsock >= 0)
        {
            stat = recv(newsock, requestBuffer,20,0);
            if(stat > 0)
            {
                printf("Receive Status= %d, Input = %s\n", stat, requestBuffer);
                stat = -2;
                stat = send(newsock, python_msg, strlen(python_msg), 0);
                printf("Send status= %d\n", stat);
                LED_D2_OFF;
            }
            else
            {
                printf("ERROR %d", stat);
                switch (stat)
                {
                    case -1:
                    {
                        printf(": remote socket closed.\n");
                        break;
                    }
                    case -2:
                    {
                        printf(": no buffers available.\n");
                        break;
                    }
                    case -57:
                    {
                        printf(": timeout - no reply from remote.\n");
                        break;
                    }
                    default:
                    printf("\n");
                }
            }
        } else printf("bad socket= %d\n", newsock);
        closesocket(newsock);
        printf("Done, press any key to repeat\n");
        getchar();
    }
} 

int getTCPIP( char a1, char a2, char a3, char a4, int port)
{
    long temp;
    //socket descriptor 
    long sock;
    char msg1[] = "GET / HTTP/1.1\r\n\r\n\0";
    //destination address
    sockaddr destAddr;
    //num of bytes received
    long numofbytes = 0;
    //data buffer
    char buff[256];
    
    memset(&destAddr, 0, 8);
    destAddr.sa_family = AF_INET;
    destAddr.sa_data[0] = (port >> 8) & 0xff;
    destAddr.sa_data[1] = port & 0xff;  
    destAddr.sa_data[2] = a1;   
    destAddr.sa_data[3] = a2;   
    destAddr.sa_data[4] = a3;       
    destAddr.sa_data[5] = a4;   
    
    //open socket
    sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    while(sock == -1) sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_TCP);
    
    //hci_unsolicited_event_handler();
    
    printf( "Client attempting connection\n");
    if( connect(sock, &destAddr, sizeof(destAddr)) < 0) 
        return(-1);
    
    printf("Connected\n");
    
    //receive TCP data
    temp = 0;
    //hci_unsolicited_event_handler();
    
    send(sock, &msg1, strlen(msg1), 0);
    printf("Receiving Data\n");
    
    //printf("Input = %s\n", msg1);
    while(1) {
        numofbytes = recv(sock, &buff, 256,0);
        
        //printf("R %d\n", numofbytes);
        newData = 1;    
        if(numofbytes != -1) { 
            closesocket(sock);
            printf("Done [%d]\n", temp);
            printf("Data: %s\n", buff);

            //hci_unsolicited_event_handler();

            return(1);
        }
        temp++;
    }
         
return(0); // We'll never get here
}

void initTCPIP(void)
{
    int t;  
    LAN_Connected = 0;
    // Start CC3000 State Machine
    resetCC3000StateMachine();
    ulCC3000DHCP = 0;
    ulCC3000Connected = 0;
    // Initialize Board and CC3000
    initDriver();
    printf("RunSmartConfig= %d\n", runSmartConfig);
    if(runSmartConfig == 1 )
    {
        // Clear flag
        //ClearFTCflag();
        unsetCC3000MachineState(CC3000_ASSOC);
        // Start the Smart Config Process
        StartSmartConfig();
        runSmartConfig = 0;
    }
    // If connectivity is good, run the primary functionality
    while(1)
    {
        if(checkWiFiConnected()) break;
        wait(1);
    }
    printf("Connected\n");
    if(!(currentCC3000State() & CC3000_SERVER_INIT))
    {
        // If we're not blocked by accept or others, obtain the latest status 
        netapp_ipconfig(&ipinfo2);                  // data is returned in the ipinfo2 structure
    }   
    printf("\n*** Wi-Go board DHCP assigned IP Address = %d.%d.%d.%d\n", ipinfo2.aucIP[3], ipinfo2.aucIP[2], ipinfo2.aucIP[1], ipinfo2.aucIP[0]);       
    LED_D3_ON;
    LAN_Connected = 1;
    t = mdnsAdvertiser(1, DevServname, sizeof(DevServname));
    printf("mDNS Status= %x\n", t);
}
    
void runTCPIPserver(void)
{
    while(1)
    {
        LED_D3_OFF;
        LAN_Connected = 0;
        LED_D2_OFF;
        printf("\n\nStarting TCP/IP Server\n");
        initTCPIP();
        sendPython(TCPIP_PORT);
//        sendTCPIP(TCPIP_PORT);
    }   
}

/*void runTCPIPclient(int a1, int a2, int a3, int a4)
{
    while(1)
    {
        LED_D3_OFF;
        LED_D2_OFF;
        printf("\n\nStarting TCP/IP Client connection\n");
        initTCPIP();
        getTCPIP( a1, a2, a3, a4, 80); // IP Address and Port of server
    }  
}*/

void runTCPIPclient(int a1, int a2, int a3, int a4, int port)
{
    int res;
    int i;
    
    LED_D3_OFF;
    // LAN_Connected = 0;
    LED_D2_OFF;
    printf("\n\nStarting TCP/IP Client connection (3 attempts)\n");
    //
    if ( LAN_Connected == 0)
        initTCPIP();
    
    i=0;
    while( i<3) {
        res=getTCPIP( a1, a2, a3, a4, port); // IP Address and Port of server
        if ( res != 1) {
            printf("[%d] Error connecting to: %d.%d.%d.%d:%d\n", ++i, a1, a2, a3, a4, port);
        } else {
            printf("Receiving Done. \n");
            wait(1);
            return;
        }
        wait(3);
    }
}
    
unsigned char checkWiFiConnected(void)
{
    int t;
    if(!(currentCC3000State() & CC3000_ASSOC)) //try to associate with an Access Point
    {
        // Check whether Smart Config was run previously. If it was, we
        // use it to connect to an access point. Otherwise, we connect to the
        // default.
        if(((ConnectUsingSmartConfig==0)&&(SmartConfigProfilestored != SMART_CONFIG_SET)) || ForceFixedSSID)
        {
            // Smart Config not set, check whether we have an SSID
            // from the assoc terminal command. If not, use fixed SSID.
            printf("Attempting SSID Connection\n");  
            ConnectUsingSSID(SSID);
        }
        //unsolicicted_events_timer_init();
        // Wait until connection is finished 
        while ((ulCC3000DHCP == 0) || (ulCC3000Connected == 0))
        {
            wait_ms(500);
            printf("waiting\n");
        }
    }
    // Check if we are in a connected state.  If so, set flags and LED
    if(ulCC3000Connected == 1)
    {
        if (obtainIpInfoFlag == FALSE)
        {
            obtainIpInfoFlag = TRUE;             // Set flag so we don't constantly turn the LED on
            LED_D3_ON;
        }
        if (obtainIpInfoFlag == TRUE)
        {
            //If Smart Config was performed, we need to send complete notification to the configure (Smart Phone App)
            if (ConnectUsingSmartConfig==1)
            {
                ConnectUsingSmartConfig = 0;
                SmartConfigProfilestored = SMART_CONFIG_SET;
            }

        }
        t = mdnsAdvertiser(1, DevServname, sizeof(DevServname));
        printf("mDNS Status= %x\n", t);
        return TRUE;
    }
    return FALSE;
}

void print_mac(void)
{
    printf("\n\nWi-Go MAC address %02x:%02x:%02x:%02x:%02x:%02x\n\n", myMAC[0], myMAC[1], myMAC[2], myMAC[3], myMAC[4], myMAC[5]);
}

void do_FTC(void)
{
    printf("Running First Time Configuration\n");
    server_running = 1;
    runSmartConfig = 1;
    initTCPIP();
    RED_OFF;
    GREEN_OFF;
    BLUE_OFF;
    userFS.FTC = 1;
    nvmem_write( NVMEM_USER_FILE_1_FILEID, sizeof(userFS), 0, (unsigned char *) &userFS);
    runSmartConfig = 0;
    SmartConfigProfilestored = SMART_CONFIG_SET;
    wlan_stop();
    printf("FTC finished\n");
}





