#include "mbed.h"
#include "doTCPIP.h"


// Serial USB port
Serial pc(USBTX, USBRX);

//Wi-Go battery charger control
DigitalOut PWR_EN1(PTB2);
DigitalOut PWR_EN2(PTB3);

int main()
{
    char c;
    // set current to 500mA since we're turning on the Wi-Fi
    PWR_EN1 = 0;
    PWR_EN2 = 1; 

    //Set baudrate to 115200 instead of the default 9600
    pc.baud (115200);
    
    initLEDs();
    Init_HostDriver();
    runSmartConfig = 0;
    ulSmartConfigFinished = 0;
//    server_running = 1;
    newData = 0;    
    socket_active_status = 0xFFFF;
    ForceFixedSSID = 0;
    
    GREEN_ON;

    // Trigger a WLAN device
    wlan_start(0);
    nvmem_read( NVMEM_USER_FILE_1_FILEID, sizeof(userFS), 0, (unsigned char *) &userFS);
    nvmem_get_mac_address(myMAC);
    printf("\x1B[2J");    //VT100 erase screen
    printf("\x1B[H");     //VT100 home
    printf("CC3000 Python demo.\n");
    print_mac();
    wlan_stop();
    printf("FTC        %i\n",userFS.FTC);
    printf("PP_version %i.%i\n",userFS.PP_version[0], userFS.PP_version[1]);
    printf("SERV_PACK  %i.%i\n",userFS.SERV_PACK[0], userFS.SERV_PACK[1]);
    printf("DRV_VER    %i.%i.%i\n",userFS.DRV_VER[0], userFS.DRV_VER[1], userFS.DRV_VER[2]);
    printf("FW_VER     %i.%i.%i\n",userFS.FW_VER[0], userFS.FW_VER[1], userFS.FW_VER[2]);

    printf("\n<0> Normal run. SmartConfig will\n    start if no valid connection exists.\n");
    printf("<1> Connect using fixed SSID : %s\n", SSID);
    printf("<2> TCP/IP client:\n    Discover public IP address.\n    Get time and date from a daytime server in Italy.\n");
    printf("<9> SmartConfig.\n");
    c = getchar();
    switch (c)
    {
        case '0':
            ForceFixedSSID = 0;
            if(!userFS.FTC)
            {
                do_FTC();
                wlan_stop();
                printf("\nPress any key to run the socket demo...\n");
                getchar();
            }
            break;
        case '1':
            ForceFixedSSID = 1;
            break;
        case '2':
            SmartConfigProfilestored = SMART_CONFIG_SET;
            // Run TCP/IP Client connection demo.
            // Discover public IP address
            runTCPIPclient( SRV_IP_OCT1, SRV_IP_OCT2, SRV_IP_OCT3, SRV_IP_OCT4, SRV_PORT);    
            wait(3);
            // Take date and time fomr daytime server (well know port 13)
            runTCPIPclient( TMSRV_IP_OCT1, TMSRV_IP_OCT2, TMSRV_IP_OCT3, TMSRV_IP_OCT4, TMSRV_PORT);
            printf("Finished - Press reset to restart.\n");
            while(1);
        case '9':
            ForceFixedSSID = 0;
//            server_running = 1;
            runSmartConfig = 1;
            initTCPIP();
//            server_running = 1;
            RED_OFF;
            GREEN_OFF;
            BLUE_OFF;
            printf("Press the reset button on your board........\n");
            while(1)
            {
                GREEN_ON;
                wait_ms(500);
                GREEN_OFF;
                wait_ms(500);
            }
        default:
            printf("Wrong selection.\n");
            printf("Reset the board and try again.\n");
    }
//    server_running = 0;
    SmartConfigProfilestored = SMART_CONFIG_SET;
    RED_OFF;
    GREEN_OFF;
    BLUE_OFF; 
    runTCPIPserver();    // Run TCP/IP Connection to host
}
