/*****************************************************************************
*
*  cc3000.h - CC3000 Function Definitions
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/

#ifndef CC3000_H
#define CC3000_H

#include "wlan.h"

//*****************************************************************************
//
//! \addtogroup cc3000
//! @{
//
//*****************************************************************************

/** CC3000 Functions
*
*/
#ifdef    __cplusplus
extern "C" {
#endif

extern DigitalOut ledr;
extern DigitalOut ledg;
extern DigitalOut ledb;
extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;

#define RED_OFF        ledr = 1;
#define RED_ON         ledr = 0;
#define RED_TOGGLE     ledr = !ledr;
#define GREEN_OFF      ledg = 1;
#define GREEN_ON       ledg = 0;
#define GREEN_TOGGLE   ledg = !ledg;
#define BLUE_OFF       ledb = 1;
#define BLUE_ON        ledb = 0;
#define BLUE_TOGGLE    ledb = !ledb;
#define LED_D1_OFF     led1 = 1;
#define LED_D1_ON      led1 = 0;
#define LED_D1_TOGGLE  led1 = !led1;
#define LED_D2_OFF     led2 = 1;
#define LED_D2_ON      led2 = 0;
#define LED_D2_TOGGLE  led2 = !led2;
#define LED_D3_OFF     led3 = 1;
#define LED_D3_ON      led3 = 0;
#define LED_D3_TOGGLE  led3 = !led3;

#define SOCKET_INACTIVE_ERR             -57
#define NUM_STATES                      6
#define MAX_SSID_LEN                    32
#define FIRST_TIME_CONFIG_SET           0xAA
#define NETAPP_IPCONFIG_MAC_OFFSET      (20)
#define CC3000_APP_BUFFER_SIZE          (5)
#define CC3000_RX_BUFFER_OVERHEAD_SIZE  (20)

// CC3000 State Machine Definitions
enum cc3000StateEnum
{
    CC3000_UNINIT           = 0x01, // CC3000 Driver Uninitialized
    CC3000_INIT             = 0x02, // CC3000 Driver Initialized
    CC3000_ASSOC            = 0x04, // CC3000 Associated to AP
    CC3000_IP_ALLOC         = 0x08, // CC3000 has IP Address
    CC3000_SERVER_INIT      = 0x10, // CC3000 Server Initialized
    CC3000_CLIENT_CONNECTED = 0x20  // CC3000 Client Connected to Server
};


/**
* Turn all LEDs Off
* @param  none
* @return none
*/
void initLEDs(void);

/** Connect to an Access Point using the specified SSID.
* @param  ssidName is a string of the AP's SSID
* @return none
*/
int ConnectUsingSSID(char * ssidName);

/** Handle asynchronous events from CC3000 device.
* @param  lEventType  Event type
* @param  data
* @param  length
* @return none
*/
void CC3000_UsynchCallback(long lEventType, char * data, unsigned char length);

/** Initialize a CC3000 device and triggers it to start operation.
* @param  none
* @return none
*/
int initDriver(void);

/** Return the highest state which we're in.
* @param  None
* @return none
*/
char highestCC3000State(void);

/** Return the current state bits.
* @param  None
* @return none
*/
char currentCC3000State(void);

/** Sets a state from the state machine.
* @param  None
* @return none
*/
void setCC3000MachineState(char stat);

/** Unsets a state from the state machine.
* Also handles LEDs.\n
* @param  None
* @return none
*/
void unsetCC3000MachineState(char stat);

/** Resets the State Machine.
* @param  None
* @return none
*/
void resetCC3000StateMachine(void);

/** Obtains the CC3000 Connection Information from the CC3000.
* @param  None
* @return none
*/
#ifndef CC3000_TINY_DRIVER
tNetappIpconfigRetArgs * getCC3000Info(void);
#endif

/** Trigger a smart configuration process on CC3000.
* It exits upon completion of the process.\n
* @param  None
* @return none
*/
void StartSmartConfig(void);

#ifdef    __cplusplus
}
#endif // __cplusplus

//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************

#endif // CC3000_H


